// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// Generic tree with homogeneous values.
    /// Use iterators to navigate the tree. Iterators are invalidated when
    /// the tree is modified. Compare the iterator to null to check for end
    /// of iteration.
template <typename T>
class hkTree
{
    public:

        HK_DECLARE_CLASS(hkTree, NewOpaque); 

        struct Node
        {
            HK_DECLARE_CLASS(Node, NewOpaque);

            Node(const T& value)
                : m_firstChild(0)
                , m_nextSibling(0)
                , m_parent(0)
                , m_value(value)
            {
            }

            Node* m_firstChild;
            Node* m_nextSibling;
            Node* m_parent;
            T m_value;
        };

            /// Tree iterator.
        typedef Node* Iter;

            /// Create an empty tree.
        inline hkTree();

            /// Destroy a tree and each of its nodes.
        inline ~hkTree();

            //
            // Insert/remove
            //

            /// Remove all values from the tree.
        inline void clear();

            /// Add a new node at the same level after iter.
        inline Iter appendSibling(_In_ Iter iter, const T& t);

            /// Add a new node at the same level after iter.
        inline Iter appendChild(_In_ Iter iter, const T& t);

            /// Remove the subtree at iterator i. Iterator i is then invalid.
        inline void remove(_In_ Iter i);

            //
            // Value
            //

            /// Set the value of a node.
        inline void setValue(_In_ Iter i, const T& t );

            /// Get the value at iter i.
        inline T& getValue(_In_ Iter i) const;

            /// Get the depth at iter i. Root nodes have depth 0. Returns -1 if the tree is empty;
        inline int getDepth(_In_ Iter i) const;

            /// Return the number of children of node at i.
        inline int getNumChildren(_In_ Iter i) const;

            //
            // Iterators
            //

            /// Get the iterator at the first root or null if empty.
        inline Iter iterGetFirst() const;

            /// Next sibling.
        inline Iter iterNext(_In_ Iter i) const;

            /// Parent.
        inline Iter iterParent(_In_ Iter i) const;

            /// First child.
        inline Iter iterChildren(_In_ Iter i) const;

            /// Next node in pre-order (children before siblings).
        inline Iter iterNextPreOrder(_In_ Iter i) const;

            /// Next node in pre-order except the current nodes children are skipped.
        inline Iter iterNextPreOrderSkippingChildren(_In_ Iter i) const;

    private:

        Node* m_root;
};

#include <Common/Base/Container/Tree/hkTree.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
