// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// Remove left horizontal links
// Skew is a right rotation when an insertion or deletion creates a left red link.
HK_INLINE void hkAATree::skew(_Inout_ Node** hlink)
{
    Node* t = *hlink;
    if ( (t->m_link[0]->m_level == t->m_level) && (t->m_level != 0) )
    {
        Node *save = t->m_link[0];
        t->m_link[0] = save->m_link[1];
        save->m_link[1] = t;
        *hlink = save;
    }
}

// Remove consecutive horizontal links
// Split is a conditional left rotation when an insertion or deletion creates two consecutive red links.
HK_INLINE void hkAATree::split(_Inout_ Node** hlink)
{
    Node* t = *hlink;
    if ( (t->m_link[1]->m_link[1]->m_level == t->m_level) && (t->m_level != 0) )
    {
        Node *save = t->m_link[1];
        t->m_link[1] = save->m_link[0];
        save->m_link[0] = t;
        *hlink = save;
        ++((*hlink)->m_level);
    }
}

HK_INLINE hkAATree::Node* hkAATree::newNode( _In_ void *data )
{
    Node* rn = new Node;

    if ( rn == HK_NULL )
        return m_nil;

    rn->m_level = 1;
    rn->m_data = m_dup ( data );
    rn->m_link[0] = rn->m_link[1] = m_nil;

    return rn;
}

HK_INLINE hkUint32 hkAATree::getSize() const
{
    return m_size;
}

HK_INLINE void* hkAATree::Iterator::first( _In_ hkAATree* tree )
{
    return start( tree, 0 ); // ie. min value
}

HK_INLINE void* hkAATree::Iterator::last( _In_ hkAATree* tree )
{
    return start( tree, 1 ); // ie. max value
}

HK_INLINE void* hkAATree::Iterator::next()
{
    return move( 1 ); // towards larger items
}

HK_INLINE void* hkAATree::Iterator::prev()
{
    return move( 0 ); // towards smaller items
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
