// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Container/StringView/hkStringView.h>

int hkStringView::find(char needle) const
{
    for (const char* it = m_begin; it != m_end; ++it)
    {
        if (*it == needle)
        {
            return hkLosslessCast<int>(it - m_begin);
        }
    }

    return npos;
}

int hkStringView::find(_In_z_ const char* needles) const
{
    for (const char* it = m_begin; it != m_end; ++it)
    {
        for (const char* needle = needles; *needle; ++needle)
        {
            if (*it == *needle)
            {
                return hkLosslessCast<int>(it - m_begin);
            }
        }
    }

    return npos;
}

int hkStringView::rfind(char needle) const
{
    for(const char* it = m_end - 1; it != m_begin - 1; --it)
    {
        if(*it == needle)
        {
            return hkLosslessCast<int>(it - m_begin);
        }
    }

    return npos;
}

int hkStringView::rfind(_In_z_ const char* needles) const
{
    for(const char* it = m_end - 1; it != m_begin - 1; --it)
    {
        for(const char* needle = needles; *needle; ++needle)
        {
            if(*it == *needle)
            {
                return hkLosslessCast<int>(it - m_begin);
            }
        }
    }

    return npos;
}

int hkStringView::compare(_In_z_ const char* s) const
{
    // out of line for the constructor
    return compare(hkStringView(s));
}

int hkStringView::compare(const hkStringView& s1) const
{
    if(m_begin == s1.m_begin)
    {
        if(const hkLong diff = hkLosslessCast<hkLong>(m_end - s1.m_end))
        {
            return diff > 0 ? 1 : -1;
        }

        return 0; // m_begin==s1.m_begin && m_end==s2.m_end
    }

    const hkStringView& s0 = *this;
    int n0 = s0.getSize();
    int n1 = s1.getSize();
    int n = hkMath::min2(n0, n1);
    if( int r = hkMemUtil::memCmp(s0.m_begin, s1.m_begin, n) )
    {
        return r;
    }
    // equal up to n
    if( n0 == n1 )
    {
        return 0;
    }
    return n0 < n1 ? -1 : +1;
}

int hkStringView::compareLower(_In_z_ const char* s) const
{
    // out of line for the constructor
    return compareLower(hkStringView(s));
}

static hkUint8 s_toLower( hkUint8 c )
{
    return (c>='A'&&c<='Z')
        ? hkUint8(c + ('a' - 'A'))
        : c;
}

int hkStringView::compareLower(const hkStringView& s1) const
{
    const hkStringView& s0 = *this;
    int n0 = s0.getSize();
    int n1 = s1.getSize();
    int n = hkMath::min2(n0, n1);
    {
        const hkUint8* u0 = reinterpret_cast<const hkUint8*>(s0.m_begin);
        const hkUint8* u1 = reinterpret_cast<const hkUint8*>(s1.m_begin);
        for( int i = 0; i < n; ++i )
        {
            int c0 = s_toLower(u0[i]);
            int c1 = s_toLower(u1[i]);
            if( c0 < c1 ) return -1;
            else if( c0 > c1 ) return +1;
        }
    }
    // equal up to n
    if( n0 == n1 )
    {
        return 0;
    }
    return n0 < n1 ? -1 : +1;
}

bool hkStringView::beginsWith(_In_z_ const char* s) const
{
    // out of line for the constructor
    return beginsWith(hkStringView(s));
}

bool hkStringView::beginsWith(const hkStringView& s) const
{
    if (s.getSize() > getSize())
    {
        return false;
    }

    return s == hkStringView(m_begin, m_begin + s.getSize());
}

bool hkStringView::endsWith(_In_z_ const char* s) const
{
    // out of line for the constructor
    return endsWith(hkStringView(s));
}

bool hkStringView::endsWith(const hkStringView& s) const
{
    if (s.getSize() > getSize())
    {
        return false;
    }

    return s == hkStringView(m_end - s.getSize(), m_end);
}

hkResult hkStringView::copy(_Out_writes_z_(n) _Out_bytecap_(dstBytes) char* dst, _In_range_(>, n) int dstBytes, _In_range_(>, 0) int n) const
{
    int curSize = getSize();
    if (n > 0)
    {
        int length = n <= curSize ? n - 1 : curSize;
        hkString::strNcpy(dst, dstBytes, m_begin, length);
        dst[length] = 0;
    }
    return n > curSize ? HK_SUCCESS : HK_FAILURE;
}

_Ret_z_ const char* hkStringView::dup() const
{
    return dup(*hkMemHeapAllocator());
}

_Ret_z_ const char* hkStringView::dup(hkMemoryAllocator& alloc) const
{
    char* dst = reinterpret_cast<char*>(hkMemoryRouter::getInstance().easyAlloc(alloc, getSize() + 1));
    hkString::strNcpy(dst, getSize()+1, m_begin, getSize());
    dst[getSize()] = 0;
    return dst;
}

void hkStringView::toString(const hkReflect::Var& var, hkStringBuf& sb, const hkStringView& extra)
{
    const hkStringView* sv = var.dynCast<hkStringView>();
    sb.set(sv->data(), sv->getSize());
}

struct hkStringView::StringImpl : public hkReflect::Detail::StringImpl
{
    StringImpl() { /*keep clang happy*/ }

    virtual hkResult setValue(void*, const hkReflect::StringType*, hkReflect::StringValue) const HK_OVERRIDE
    {
        HK_ASSERT_NO_MSG(0x7a1cac1f,0); //fixme
        return HK_FAILURE;
    }

    virtual hkResult getValue(const void*, const hkReflect::StringType*, _Out_ hkReflect::StringValue* val) const HK_OVERRIDE
    {
        HK_ASSERT_NO_MSG(0x42e2846a,0); //fixme
        *val = hkReflect::StringValue();
        return HK_FAILURE;
    }
};

hkStringView hkStringView::strStr(const hkStringView& needle)
{
    // The reason we early out here is so we can set a lower limit on "end" below.
    if ( getSize() < needle.getSize() )
    {
        return hkStringView();
    }

    // The zero-length needle always has a match.
    if ( needle.getSize() == 0 )
    {
        return hkStringView( m_begin, m_begin );
    }

    const char* current = m_begin;
    const char* const end = m_end - needle.getSize() + 1;
    const char* const needleEnd = needle.m_end;
    do
    {
        const char* haystackCurrent = current;
        const char* needleCurrent = needle.m_begin;
        while ( *haystackCurrent == *needleCurrent )
        {
            ++needleCurrent;
            ++haystackCurrent;
            if ( needleCurrent == needleEnd )
            {
                return hkStringView( current, haystackCurrent );
            }
        }
        ++current;
    }
    while ( current < end );

    return hkStringView();
}

_Ret_maybenull_ const char* hkStringView::strChr(int needle) const
{
    const char* current = m_begin;
    const char* const end = m_end;
    while ( current < end )
    {
        if ( *current == needle )
        {
            return current;
        }
        ++current;
    }
    return HK_NULL;
}

const hkStringView::StringImpl hkStringView::s_impl;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
