// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

namespace hkReflect { namespace Tracker {

#ifdef HK_MEMORY_TRACKER_ENABLE
    HK_EXPORT_COMMON void HK_CALL hkStringMapHandlerInternal(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot,
        bool isStorageMap, bool valIsPtr);

    template <bool VAL_IS_POINTER, bool IS_STORAGE_MAP, bool IS_TRACKED> struct hkStringMapHandlerHelper;

    template <bool VAL_IS_POINTER, bool IS_STORAGE_MAP>
    struct hkStringMapHandlerHelper<VAL_IS_POINTER, IS_STORAGE_MAP, true>
    {
        static void HK_CALL func(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot)
        {
            
            hkStringMapHandlerInternal(var, snapshot, IS_STORAGE_MAP, VAL_IS_POINTER);
        }
    };

    template <bool VAL_IS_POINTER, bool IS_STORAGE_MAP>
    struct hkStringMapHandlerHelper<VAL_IS_POINTER, IS_STORAGE_MAP, false>
    {
        static void HK_CALL func(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot) {}
    };

    template <typename T, typename A, bool IS_STORAGE_MAP>
    struct hkStringMapHandler : public hkStringMapHandlerHelper<
        hkTrait::IsPointerType< HK_REFLECT_RESOLVE(T) >::result,
        IS_STORAGE_MAP,
        hkContainerAllocatorIsTracked<A>::result> {};
#else
    template <typename T, typename A, bool IS_STORAGE_MAP>
    struct hkStringMapHandler { static void HK_CALL func(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot) {} };
#endif
}}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
