// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Container/StringMap/hkStringMap.h>
#include <Common/Base/Container/StringMap/hkCachedHashMap.cxx>

template class hkCachedHashMap<hkStringMapOperations, hkContainerTempAllocator>;
template class hkCachedHashMap<hkStringMapOperations, hkContainerDebugAllocator>;
template class hkCachedHashMap<hkStringMapOperations, hkContainerHeapAllocator>;

#ifdef HK_MEMORY_TRACKER_ENABLE
#include <Common/Base/Memory/Tracker/hkMemoryTrackerSnapshot.h>

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    struct Elem
    {
        hkLong hash;
        const char* key;
        const void* value;
    };
    struct AnyMap
    {
        const Elem* m_elem;
        int m_numElems;
        int m_hashMod;
    };
}

void HK_CALL hkReflect::Tracker::hkStringMapHandlerInternal(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot,
    bool isStorageMap, bool valIsPtr)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;

    const AnyMap* map = static_cast<const AnyMap*>(var.getAddress());

    // Track the buffer.
    HK_ASSERT_NO_MSG(0x3a122f69, map->m_hashMod);
    snapshot.addLinkedBlock(hkMemoryTrackerSnapshot::Block(
        isStorageMap ? "buffer_hkStorageStringMap" : "buffer_hkStringMap",
        map->m_elem, (map->m_hashMod + 1) * sizeof(Elem)), true);

    // Track the elements.
    if (map->m_numElems)
    {
        int added = 0;
        hkArrayView<const Elem> elems(map->m_elem, map->m_hashMod + 1);
        for (int i = 0; i < elems.getSize(); ++i)
        {
            if (elems[i].hash != -1)
            {
                if (elems[i].key)
                {
                    if (isStorageMap)
                    {
                        // String is owned.
                        snapshot.addLinkedBlock(hkMemoryTrackerSnapshot::Block(
                            "buffer_hkStorageStringMap_elem",
                            elems[i].key,
                            hkString::strLen(elems[i].key) + 1), true);
                        
                        snapshot.addLinkedBlock(hkMemoryTrackerSnapshot::Block(
                            "buffer_hkStorageStringMap_elem_easyAlloc", elems[i].key - 16, 16), true);
                    }
                    else
                    {
                        // String is external.
                        snapshot.addLink(elems[i].key);
                    }
                }
                if (valIsPtr)
                {
                    snapshot.addLink(elems[i].value);
                }
                ++added;
            }
        }
        HK_ASSERT_NO_MSG(0x43550861, added == map->m_numElems);
    }
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
