// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/StringMap/hkStringMap.h>

/// Like hkStringMap except that the keys are copied and managed internally.
template <typename V, typename Allocator=hkContainerHeapAllocator>
class hkStorageStringMap : public hkStringMap<V, Allocator>
{
    public:

        typedef typename hkStringMap<V>::Iterator Iterator;

        HK_DECLARE_CLASS(hkStorageStringMap, NewTemplate, NonCopyable);
        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true, handler=&hkReflect::Tracker::hkStringMapHandler<V, Allocator, true>::func));

        hkStorageStringMap()
        {
        }

        ~hkStorageStringMap()
        {
            clear();
        }

            /// Insert key with associated value val.
            /// If key already exists it is overwritten. The key string is copied
        HK_INLINE const char* insert( _In_z_ const char* key, V val )
        {
            Iterator it = this->findKey(key);
            const char* ret;
            if( ! this->isValid(it) )
            {
                ret = hkString::strDup(key, Allocator().get(this) );
                hkStringMap<V,Allocator>::insert( ret, val );
            }
            else
            {
                ret = this->getKey(it);
                this->setValue(it, val);
            }
            return ret;
        }

        V getOrInsert(_In_z_ const char* key, V ifNotFound)
        {
            Iterator it = this->findKey(key);
            if( this->isValid(it) )
            {
                return this->getValue(it);
            }
            else
            {
                this->insert(key,ifNotFound);
                return ifNotFound;
            }
        }

            /// Remove pair at "it".
        void remove( _In_ Iterator it )
        {
            char* k = (char*)this->m_map.getKey(it);
            hkString::strFree( k, Allocator().get(this) );
            hkStringMap<V,Allocator>::remove( it );
        }

            /// If key present, remove it and return HK_SUCCESS. Otherwise return HK_FAILURE.
        hkResult remove( _In_z_ const char* key )
        {
            Iterator it = this->findKey(key);
            if( this->isValid(it) )
            {
                this->remove(it);
                return HK_SUCCESS;
            }
            return HK_FAILURE;
        }

            /// Remove all keys from the map.
        void clear()
        {
            for( Iterator it = hkStringMap<V,Allocator>::getIterator(); hkStringMap<V,Allocator>::isValid(it); it = hkStringMap<V,Allocator>::getNext(it) )
            {
                char* k = (char*)this->m_map.getKey(it);
                hkString::strFree( k, Allocator().get(this) );
            }
            hkStringMap<V,Allocator>::clear();
        }

            /// Swap all data with another map.
        void swap( hkStorageStringMap& other )
        {
            this->m_map.swap( other.m_map );
        }

        void merge( const hkStringMap<V,Allocator>& other )
        {
            typedef typename hkStringMap<V,Allocator>::Iterator OtherIterator;
            for( OtherIterator it = other.getIterator(); other.isValid(it); it = other.getNext(it) )
            {
                insert( other.getKey(it), other.getValue(it) );
            }
        }
};

#include <Common/Base/_Auto/TemplateTypes/hkStorageStringMap_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
