// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

    /// Class providing utilities for building and searching string dictionaries.
class HK_EXPORT_COMMON hkStringDictionary
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkStringDictionary);

            /// Initializes the dictionary
        hkStringDictionary(_In_count_(numStrings) const hkCString* strings, int numStrings);

            /// Destructs the dictionary
        ~hkStringDictionary();

            /// Inserts a new word into the dictionary.
        void insert( _In_z_ const char* word );

            /// Removes a given word from the dictionary, returning true if the word was in the dictionary.
        bool remove( _In_z_ const char* word );

            /// Remove all words from the dictionary
        void clear();

            /// Returns true if the dictionary contains the word, false otherwise. Does a linear search through
            /// all dictionary entries.
        bool containsWord( _In_z_ const char* word ) const;

            /// Find strings in the dictionary that contain the given pattern, with a wildcard character accepting one or more characters
            /// in its place. The given array is filled using the given allocator.
        void findMatches( _In_z_ const char* pattern, hkArray<const char*>& resultsOut, hkMemoryAllocator& resultsAllocator, const char wildcard = 0, const bool caseSensitive = true ) const;
            /// Find strings in the dictionary that contain the given pattern, with a wildcard character accepting one or more characters
            /// in its place.
        void findMatches( _In_z_ const char* pattern, hkArray<const char*>& resultsOut, const char wildcard = '\0', const bool caseSensitive = true ) const;

            /// Copies all words from the dictionary into the given array.
        void copyWordsFromDictionary( hkArray<const char*>& wordsOut ) const;

            /// Return the number of strings in the dictionary.
        int getSize() const;

    protected:
            /// String array containing the words in the dictionary
        hkArray<hkCString> m_dictionary;

            /// Return the character index of the first occurrence of the pattern, with wildcard, in the given text.
        int naiveStringSearch(  _In_z_ const char* text, _In_z_ const char* pattern, const char wildcard = 0, const bool caseSensitive = true ) const;

            /// Compare the two characters following the case-sensitivity rules for this dictionary.
            /// Returns true if they match following those rules, false otherwise.
        static bool charCmpFollowingCaseRules( const char a, const char b, bool caseSensitive );

};

#include <Common/Base/Container/StringDictionary/hkStringDictionary.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
