// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

/// UTF-8 string utilities.
namespace hkUtf8
{
    namespace Detail
    {
        /// Converts a UTF-16 encoded string into a UTF-8 encoded string.
        /// \p src may be null terminated and/or a limit on the number of source code units (hkUint16)
        /// may be supplied. \p srcCount == -1 means no limit; in that case \p src must be
        /// null-terminated. The source string is read until \p srcCount code units (hkUint16)
        /// are read, or a null terminator is found, whichever comes first.
        /// At most dstCap code units (char) are written into dst, and if dstCap is non-zero
        /// then dst is always null terminated, even if the source string was not.
        /// The number of code units (char) required to hold the null-terminated result is
        /// returned in any case. Thus utf8FromUtf16(HK_NULL, 0, src) can be used to determine
        /// the required number of code units (char).
        HK_EXPORT_COMMON int HK_CALL utf8FromUtf16(_Out_writes_(dstCap) char* dst, int dstCap, _In_reads_z_(srcCount) const hkUint16* src, int srcCount = -1);

        /// Converts a UTF-8 encoded string into a UTF-16 encoded string.
        /// \p src may be null terminated and/or a limit on the number of source code units (char)
        /// may be supplied. \p srcCount == -1 means no limit; in that case \p src must be
        /// null-terminated. The source string is read until \p srcCount code units (char)
        /// are read, or a null terminator is found, whichever comes first.
        /// At most dstCap code units (hkUint16) are written into dst, and if dstCap is non-zero
        /// then dst is always null terminated, even if the source string was not.
        /// The number of code units (hkUint16) required to hold the null-terminated result is
        /// returned in any case. Thus utf16FromUtf8(HK_NULL, 0, src) can be used to determine
        /// the required number of code units (hkUint16).
        HK_EXPORT_COMMON int HK_CALL utf16FromUtf8(_Out_writes_(dstCap) hkUint16* dst, int dstCap, _In_reads_z_(srcCount) const char* src, int srcCount = -1);

        /// Returns the number of code units (hkUint16) required to store the UTF-16 encoding
        /// of the given UTF-8 encoded string.
        /// The input string \str is read until a null terminator is found or \srcCount code units (char)
        /// are read, whichever comes first. \srcCount == -1 means no limit; in that case \p src
        /// must be null-terminated.
        /// The length always includes one code unit (hkUint16) for the null terminator, even if
        /// the input string was not null-terminated.
        HK_EXPORT_COMMON int HK_CALL utf16LengthForUtf8(_In_reads_z_(srcCount) const char* str, int srcCount = -1);

        /// Returns the number of code units (char) required to store the UTF-8 encoding
        /// of the given UTF-16 encoded string.
        /// The input string \str is read until a null terminator is found or \srcCount code units (hkUint16)
        /// are read, whichever comes first. \srcCount == -1 means no limit; in that case \p src
        /// must be null-terminated.
        /// The length always includes one code unit (char) for the null terminator, even if
        /// the input string was not null-terminated.
        HK_EXPORT_COMMON int HK_CALL utf8LengthForUtf16(_In_reads_z_(srcCount) const hkUint16* str, int srcCount = -1);

        /// Validates whether the given string is a valid UTF-8 string. If it is valid,
        /// -1 is returned, otherwise the index of the first invalid code unit (char) is
        /// returned
        HK_EXPORT_COMMON int HK_CALL findFirstInvalidUtf8(_In_reads_z_(srcCount) const char* str, int srcCount = -1);

        /// Validates whether the given string is a valid UTF-16 string. If it is valid
        /// -1 is returned, otherwise the index of the first invalid code unit (hkUint16) is
        /// returned.
        HK_EXPORT_COMMON int HK_CALL findFirstInvalidUtf16(_In_reads_z_(srcCount) const hkUint16* str, int srcCount = -1);

        /// Converts from UTF-32 to UTF-8. \p src may be null terminated and/or a
        /// limit on the number of source characters may be supplied. At most dstCap
        /// code units (char) are written into dst, and if dstCap is dstCap is non-zero, dst is
        /// always null terminated. The number of char's required to hold the null
        /// terminated result is returned in any case. Thus
        /// utf8FromUtf32(HK_NULL, 0, src) can be used to determine the required
        /// number of char's.
        HK_EXPORT_COMMON int HK_CALL utf8FromUtf32(_Out_writes_(dstCap) char* dst, int dstCap, _In_reads_z_(srcCount) const hkUint32* src, int srcCount = -1);

        /// Converts a UTF-8 encoded string into a UTF-32 encoded string.
        /// \p src may be null terminated and/or a limit on the number of source code units (char)
        /// may be supplied. \p srcCount == -1 means no limit; in that case \p src must be
        /// null-terminated. The source string is read until \p srcCount code units (char)
        /// are read, or a null terminator is found, whichever comes first.
        /// At most dstCap code units (hkUint32) are written into dst, and if dstCap is non-zero
        /// then dst is always null terminated, even if the source string was not.
        /// The number of code units (hkUint32) required to hold the null-terminated result is
        /// returned in any case. Thus utf32FromUtf8(HK_NULL, 0, src) can be used to determine
        /// the required number of code units (hkUint32).
        HK_EXPORT_COMMON int HK_CALL utf32FromUtf8(_Out_writes_(dstCap) hkUint32* dst, int dstCap, _In_reads_z_(srcCount) const char* src, int srcCount = -1);

        /// Returns the number of code units (hkUint32) required to store the UTF-32 encoding
        /// of the given UTF-8 encoded string.
        /// The input string \str is read until a null terminator is found or \srcCount code units (char)
        /// are read, whichever comes first. \srcCount == -1 means no limit; in that case \p src
        /// must be null-terminated.
        /// The length always includes one code unit (hkUint32) for the null terminator, even if
        /// the input string was not null-terminated.
        HK_EXPORT_COMMON int HK_CALL utf32LengthForUtf8(_In_reads_z_(srcCount) const char* str, int srcCount = -1);

        /// Returns the number of code units (char) required to store the UTF-8 encoding
        /// of the given UTF-32 encoded string.
        /// The input string \str is read until a null terminator is found or \srcCount code units (hkUint32)
        /// are read, whichever comes first. \srcCount == -1 means no limit; in that case \p src
        /// must be null-terminated.
        /// The length always includes one code unit (char) for the null terminator, even if
        /// the input string was not null-terminated.
        HK_EXPORT_COMMON int HK_CALL utf8LengthForUtf32(_In_reads_z_(srcCount) const hkUint32* str, int srcCount = -1);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
