// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// Note this is relied upon for compilation units to avoid duplicating symbols
#ifndef HK_UTF8_CXX
#define HK_UTF8_CXX

#if defined(HK_UTF8_SUPPORT_MANAGED_STRING)

#include <wchar.h>

#ifndef WCHAR_MAX
    #error wchar.h should provide WCHAR_MAX
#endif

#pragma managed(push, on)

#include <vcclr.h>

hkUtf8::Utf8FromWide::Utf8FromWide(System::String^ s)
{
    if(s != nullptr)
    {
        pin_ptr<const wchar_t> sWchars = PtrToStringChars(s);
        init(sWchars);
    }
    else
    {
        m_utf8.clearAndDeallocate();
        HK_ASSERT_NO_MSG(0x96bbe2c, m_utf8.begin() == HK_NULL);
    }
}

hkUtf8::WideFromUtf8::operator System::String^() const
{
    if( this->cString() == HK_NULL )
    {
        return nullptr;
    }

    return gcnew System::String( this->cString() );
}

#pragma managed(pop)

#endif

#if defined(HK_UTF8_SUPPORT_CX_STRING)

hkUtf8::Utf8FromWide::Utf8FromWide(Platform::String^ s)
{
    if(s != nullptr)
    {
        wchar_t const* sWchars = s->Data();
        init(sWchars);
    }
    else
    {
        m_utf8.clearAndDeallocate();
        HK_ASSERT_NO_MSG(0x22440943, m_utf8.begin() == HK_NULL);
    }
}

hkUtf8::WideFromUtf8::operator Platform::String^() const
{
    if( this->cString() == HK_NULL )
    {
        return nullptr;
    }

    return ref new Platform::String( this->cString() );
}

#endif

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
