// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hkStringPtr::hkStringPtr()
    : m_stringAndFlag(nullptr)
{
}

inline hkStringPtr::hkStringPtr(nullptr_t)
    : m_stringAndFlag(nullptr)
{
}

inline const char* hkStringPtr::cString() const
{
    return hkClearBits(m_stringAndFlag, OWNED_FLAG);
}

inline hkStringPtr::operator const char*() const
{
    return cString();
}

inline bool hkStringPtr::isNullOrEmpty() const
{
    const char* t = cString();
    return t == nullptr || t[0] == '\0';
}

inline void hkStringPtr::swap(hkStringPtr& other)
{
    
    char* const tmp = other.m_stringAndFlag;
    other.m_stringAndFlag = m_stringAndFlag;
    m_stringAndFlag = tmp;
}

inline int hkStringPtr::compareTo(_In_opt_z_ const char* s) const
{
    const char* t = cString();
    if (t && s) // both non null
    {
        return hkString::strCmp(t, s);
    }
    return t ? 1 : (s ? -1 : 0); // null is "less" than all other non null strings
}

inline hkBool32 hkStringPtr::operator==(_In_opt_z_ const char* cptr) const
{
    return compareTo(cptr) == 0;
}

inline hkBool32 hkStringPtr::operator!=(_In_opt_z_ const char* cptr) const
{
    return compareTo(cptr) != 0;
}

inline hkBool32 hkStringPtr::operator<(_In_opt_z_ const char* cptr) const
{
    return compareTo(cptr) < 0;
}

inline hkBool32 hkStringPtr::operator<=(_In_opt_z_ const char* cptr) const
{
    return compareTo(cptr) <= 0;
}

inline hkBool32 hkStringPtr::operator>(_In_opt_z_ const char* cptr) const
{
    return compareTo(cptr) > 0;
}

inline hkBool32 hkStringPtr::operator>=(_In_opt_z_ const char* cptr) const
{
    return compareTo(cptr) >= 0;
}

inline hkBool32 hkStringPtr::startsWith(_In_z_ const char* s) const
{
    return hkString::beginsWith(cString(), s);
}

inline hkBool32 hkStringPtr::endsWith(_In_z_ const char* s) const
{
    return hkString::endsWith(cString(), s);
}

inline hkBool32 hkStringPtr::contains(_In_z_ const char* s) const
{
    return (hkString::strStr(cString(), s) != nullptr);
}

inline char hkStringPtr::operator[](int idx) const
{
    const char* strAddr = this->cString();
    HK_ASSERT_NO_MSG(0x2216fadd, strAddr != nullptr);
    HK_ON_DEBUG(bool idxInRange = (0 <= idx) && (idx < hkString::strLen(strAddr)));
    HK_ASSERT_NO_MSG(0x73c986fd, idxInRange);
    return strAddr[idx];
}



HK_ALWAYS_INLINE hkBool32 operator==(_In_opt_z_ const char* l, const hkStringPtr& r)
{
    return r == l;
}

HK_ALWAYS_INLINE hkBool32 operator!=(_In_opt_z_ const char* l, const hkStringPtr& r)
{
    return r != l;
}

HK_ALWAYS_INLINE hkBool32 operator<(_In_opt_z_ const char* l, const hkStringPtr& r)
{
    return r > l;
}

HK_ALWAYS_INLINE hkBool32 operator<=(_In_opt_z_ const char* l, const hkStringPtr& r)
{
    return r >= l;
}

HK_ALWAYS_INLINE hkBool32 operator>(_In_opt_z_ const char* l, const hkStringPtr& r)
{
    return r < l;
}

HK_ALWAYS_INLINE hkBool32 operator>=(_In_opt_z_ const char* l, const hkStringPtr& r)
{
    return r <= l;
}

HK_ALWAYS_INLINE hkBool32 operator==(const hkStringPtr& l, const hkStringPtr& r)
{
    return l == r.cString();
}

HK_ALWAYS_INLINE hkBool32 operator!=(const hkStringPtr& l, const hkStringPtr& r)
{
    return l != r.cString();
}

HK_ALWAYS_INLINE hkBool32 operator<(const hkStringPtr& l, const hkStringPtr& r)
{
    return l < r.cString();
}

HK_ALWAYS_INLINE hkBool32 operator<=(const hkStringPtr& l, const hkStringPtr& r)
{
    return l <= r.cString();
}

HK_ALWAYS_INLINE hkBool32 operator>(const hkStringPtr& l, const hkStringPtr& r)
{
    return l > r.cString();
}

HK_ALWAYS_INLINE hkBool32 operator>=(const hkStringPtr& l, const hkStringPtr& r)
{
    return l >= r.cString();
}

#ifdef HK_MOVE_SEMANTICS
inline hkStringPtr::hkStringPtr(hkStringPtr&& other)
{
    m_stringAndFlag = other.m_stringAndFlag;
    other.m_stringAndFlag = nullptr;
}
#endif

namespace hkReflect {
    namespace Tracker {
        HK_EXPORT_COMMON void hkStringPtrHandler(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
