// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline void hkStringBuf::setLength( _In_range_(>=, 0) int length )
{
    HK_ASSERT_NO_MSG(0x3b46ed0d, length >= 0);
    m_string.setSize(length+1);
    m_string[length] = 0;
}

inline hkStringBuf::hkStringBuf()
{
    setLength(0);
}

_Ret_maybenull_z_
HK_ALWAYS_INLINE hkStringBuf::operator const char*() const
{
    return m_string.begin();
}

HK_ALWAYS_INLINE hkStringBuf::operator hkStringView() const
{
    return hkStringView(m_string.begin(), m_string.end()-1);
}

_Ret_z_
inline const char* hkStringBuf::cString() const
{
    return m_string.begin();
}

inline int hkStringBuf::getLength() const
{
    return m_string.getSize() - 1;
}

HK_ALWAYS_INLINE char hkStringBuf::operator[] (int i) const
{
    return m_string[i];
}

HK_ALWAYS_INLINE bool operator!=( const hkStringBuf& lhs, const hkStringBuf& rhs ) { return !( lhs == rhs ); }

HK_ALWAYS_INLINE bool operator>( _In_z_ const char* str, const hkStringBuf& buf ) { return buf < str; }
HK_ALWAYS_INLINE bool operator<( _In_z_ const char* str, const hkStringBuf& buf ) { return buf > str; }
HK_ALWAYS_INLINE bool operator==( _In_z_ const char* str, const hkStringBuf& buf ) { return buf == str; }
HK_ALWAYS_INLINE bool operator!=( _In_z_ const char* str, const hkStringBuf& buf ) { return buf != str; }

HK_ALWAYS_INLINE bool operator>( const hkStringBuf& lhs, const hkStringBuf& rhs ) { return lhs.compareTo(rhs) > 0; }
HK_ALWAYS_INLINE bool operator<( const hkStringBuf& lhs, const hkStringBuf& rhs ) { return lhs.compareTo(rhs) < 0; }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
