// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// Return the localized string for "msg"
_Ret_z_
extern const char* hkLoc(_In_z_ const char* msg);

    /// Return the localized string for "msg" with an additional hint "context".
    /// e.g. For a British English locale;
    /// e.g. hkLoc2("The verb", "Fall")=="Fall" and hkLoc2("Season","Fall")=="Autumn"
_Ret_z_
extern const char* hkLoc2(_In_z_ const char* context, _In_z_ const char* str);

    /// Localize considering plural forms.
    /// Often the arguments will be format strings, in this case note that the return value
    /// will need to be formatted in the usual way.
    /// e.g. hkLocNum("%i match of %i found", "%i matches of %i found", numMatches);
_Ret_z_
extern const char* hkLocNum(_In_z_ const char* singular, _In_z_ const char* plural, int n);

    /// Like hkLocNum except with a context hint.
_Ret_z_
extern const char* hkLocNum2(_In_z_ const char* context, _In_z_ const char* singular, _In_z_ const char* plural, int n);

    /// Mark a string to be translated, but don't actually translate it yet.
#define hkLocTag(str) str

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
