// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/String/hkInternedString.h>
#include <Common/Base/Container/StringMap/hkStringMap.h>
#include <Common/Base/Container/String/hkStringPtr.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

/// Default base class for hkInternedString registries
class HK_EXPORT_COMMON hkInternedStringRegistryBase : public hkReferencedObject
{
public:

    _Ret_maybenull_z_
    const char* _addCopy(_In_opt_z_ const char* str);

    _Ret_maybenull_z_
    const char* _addStatic(_In_opt_z_ const char* str);

protected:

    template<bool Copy>
    _Ret_maybenull_z_
    const char* add(_In_opt_z_ const char* str);

    hkCriticalSection m_mutex;

    hkArray<hkStringPtr> m_strings;
    hkStringMap<const char*> m_idFromString;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
