// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename Registry>
hkInternedString<Registry>::hkInternedString() : m_string(HK_NULL) {}

template<typename Registry>
hkInternedString<Registry>::hkInternedString(Value value)
{
    m_string = value.get();
}

template<typename Registry>
bool hkInternedString<Registry>::isValid() const
{
    return m_string != HK_NULL;
}
template<typename Registry>
int hkInternedString<Registry>::getLength() const
{
    return m_string ? hkString::strLen(m_string) : 0;
}

template<typename Registry>
bool hkInternedString<Registry>::operator==(const hkInternedString& other) const
{
    return m_string == other.m_string;
}

template<typename Registry>
bool hkInternedString<Registry>::operator!=(const hkInternedString& other) const
{
    return m_string != other.m_string;
}

template<typename Registry>
bool hkInternedString<Registry>::operator==(_In_opt_z_ const char* other) const
{
    if (m_string == other)
        return true;

    return (m_string && other) && !hkString::strCmp(other, m_string);
}

template<typename Registry>
bool hkInternedString<Registry>::operator!=(_In_opt_z_ const char* other) const
{
    return (m_string && other) && hkString::strCmp(other, m_string);
}

template<typename Registry>
HK_ALWAYS_INLINE bool operator==( _In_opt_z_ const char* l, const hkInternedString<Registry>& r )
{
    return r == l;
}

template<typename Registry>
HK_ALWAYS_INLINE bool operator!=( _In_opt_z_ const char* l, const hkInternedString<Registry>& r )
{
    return r != l;
}

template<typename Registry>
void hkInternedString<Registry>::registerString( _In_z_ const char* str)
{
    m_string = Registry::addCopy(str).get();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
