// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// A string stored into a shared registry.
template<typename Registry>
class hkInternedString
{
    public:

        HK_DECLARE_CLASS( hkInternedString, New, Reflect );
        HK_REFLECT_AS_STRING_UTF8_IMMUTABLE( &Registry::s_impl );

        class Value
        {
        public:
            HK_DECLARE_CLASS(Value, NewPlacement);
        private:
            const char* get() const { return m_ptr; }
            friend Registry;
            friend hkInternedString;
            Value(const char* s) : m_ptr(s) {}
            const char* m_ptr;
        };
        /// Empty constructor
        hkInternedString();

        /// Construct from a string
        hkInternedString( Value value );

        /// Return true if the string is not null
        bool isValid() const;

        /// Get the string
        _Ret_maybenull_z_
        operator const char*() const { return getString(); }

        /// Get the string
        _Ret_maybenull_z_
        const char* getString() const { return m_string; }

        /// Number of characters in this string.
        int getLength() const;

        // Comparison operators
        bool operator==( const hkInternedString& other ) const;
        bool operator!=( const hkInternedString& other ) const;

        bool operator==( _In_opt_z_ const char* other ) const;
        bool operator!=( _In_opt_z_ const char* other ) const;

    private:

        friend Registry;
        void registerString( _In_z_ const char* str );

        const char* m_string;   
};

template<typename Registry>
bool operator==( _In_opt_z_ const char* l, const hkInternedString<Registry>& r );
template<typename Registry>
bool operator!=( _In_opt_z_ const char* l, const hkInternedString<Registry>& r );

#include <Common/Base/Container/String/hkInternedString.inl>
#include <Common/Base/_Auto/TemplateTypes/hkInternedString_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
