// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


template<typename count>
hkFixedString<count>::hkFixedString()
{
    m_string[0] = 0;
}

template<typename count>
hkFixedString<count>::hkFixedString(_In_opt_z_ const char* str)
{
    set(str);
}

template<typename count>
void hkFixedString<count>::set(_In_opt_z_ const char* str)
{
    if (str)
    {
        // Maximum length is one less than count so the string can be null terminated.
        int maxLen = getSize() - 1;
        hkString::strNcpy(m_string, getSize()*sizeof(char), str, maxLen);
        m_string[maxLen] = 0;
    }
    else
    {
        m_string[0] = 0;
    }
}

template<typename count>
bool hkFixedString<count>::isValid() const
{
    return true;
}

template<typename count>
int hkFixedString<count>::getLength() const
{
    return hkString::strLen(m_string);
}

template<typename count>
bool hkFixedString<count>::operator==(const hkFixedString& other) const
{
    return !hkString::strCmp(m_string, other.m_string);
}

template<typename count>
bool hkFixedString<count>::operator!=(const hkFixedString& other) const
{
    return hkString::strCmp(m_string, other.m_string);
}

template<typename count>
bool hkFixedString<count>::operator==(_In_opt_z_ const char* other) const
{
    return other && !hkString::strCmp(other, m_string);
}

template<typename count>
bool hkFixedString<count>::operator!=(_In_opt_z_ const char* other) const
{
    return other && hkString::strCmp(other, m_string);
}


template<typename count>
const hkReflect::Detail::StringPropertyImpl hkFixedString<count>::s_impl(
    &hkReflect::Detail::erasedGetterCall< hkFixedString<count>, const char*, &hkFixedString<count>::getString >,
    &hkReflect::Detail::erasedSetterCall<void>::call< hkFixedString<count>, const char*, &hkFixedString<count>::set >);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
