// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/hkBaseTypes.h>
#include <Common/Base/Container/String/hkString.h>

/// This class is used to store a fixed size char c-string. This exists because currently RPC doesn't
/// support hkStringPtr for hk::Vars.
///
/// (See Bug 9643296:RPC doesn't support hkStringPtr types)
///
/// Currently hkPreBuild cannot handle fields dependent on integer template arguments. Instead we use a typename
/// Usage is therefore something like: hkFixedString<char[64]> for a 64 byte string. The
/// actual type isn't important, just the size that the typename resolves to.
/// (See Bug 9656246: hkPreBuild cannot handle fields dependent on integer template arguments)

template<typename count>
class hkFixedString
{
public:
    HK_DECLARE_CLASS(hkFixedString, New, Reflect, Pod);
    HK_REFLECT_AS_STRING_UTF8_MUTABLE(&hkFixedString<count>::s_impl);

    /// Empty constructor
    hkFixedString();

    /// Construct from a string
    hkFixedString(_In_opt_z_ const char* str);

    /// Return true if the string is not null
    bool isValid() const;

    /// Get the string
    _Ret_maybenull_z_
    operator const char*() const { return getString(); }

    /// Get the string
    _Ret_maybenull_z_
    const char* getString() const { return m_string; }

    /// Set from a string
    void set(_In_opt_z_ const char* str);

    /// Number of characters in this string.
    int getLength() const;

    // Comparison operators
    bool operator==(const hkFixedString& other) const;
    bool operator!=(const hkFixedString& other) const;

    bool operator==(_In_opt_z_ const char* other) const;
    bool operator!=(_In_opt_z_ const char* other) const;

public:

    // Custom reflection implementation
    static const hkReflect::Detail::StringPropertyImpl s_impl;

private:
    int getSize() const { return sizeof(count); }

    char m_string[sizeof(count)];
};

#include <Common/Base/Container/String/hkFixedString.inl>
#include <Common/Base/_Auto/TemplateTypes/hkFixedString_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
