// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
// String Internal Representation
//

//
// private methods
//

// inline methods used by other inlines come first


HK_INLINE int hkStringOld::getLength() const
{
    // the length of the string is the size -1 (the null termination)
    return m_string.getSize() - 1;
}

_Ret_maybenull_z_
HK_INLINE const char* hkStringOld::cString() const
{
    return m_string.begin();
}

HK_INLINE void hkStringOld::setLength( int length )
{
    m_string.setSize( length + 1 );
}

//
// constructors
//

HK_INLINE hkStringOld::hkStringOld()
:m_string(1, 0) // "" string, size==1 => length==0
{
}

HK_INLINE hkStringOld::hkStringOld(const hkStringOld& other)
{
    setLength( other.getLength() );
    hkString::memCpy( m_string.begin(), other.cString(), other.m_string.getSize() );
}

HK_INLINE hkStringOld::hkStringOld(_In_opt_z_ const char* s)
{
    if( s != HK_NULL )
    {
        setLength( hkString::strLen(s) );
        hkString::memCpy(m_string.begin(), s, m_string.getSize() ); // copy null too
    }
    else
    {
        // empty string
        setLength(0);
        m_string[0] = 0;
    }
}

HK_INLINE hkStringOld::hkStringOld(_In_count_(capacity) char* ptr, int size, int capacity)
{
    m_string.setDataAutoFree( ptr, size, capacity );
}

HK_INLINE hkStringOld::hkStringOld(_In_reads_(len) const char* buf, int len)
{
    HK_ASSERT_NO_MSG(0x1b0d49f3, len >= 0);
    setLength( len );
    hkString::memCpy( m_string.begin(), buf, len );
    m_string[len] = 0; // null terminate
}

HK_INLINE hkStringOld& hkStringOld::operator= (const hkStringOld& other)
{
    setLength( other.getLength() );
    hkString::memCpy( m_string.begin(), other.cString(), m_string.getSize() );
    return *this;
}

HK_INLINE hkStringOld& hkStringOld::operator= (_In_opt_z_ const char* s)
{
    if(s != HK_NULL && *s != 0)
    {
        int slen = hkString::strLen(s);
        setLength( slen );
        hkString::memCpy(m_string.begin(), s, slen+1); // copy null too
    }
    else
    {
        setLength(0);
        m_string[0] = 0;
    }
    return *this;
}

HK_INLINE hkStringOld::~hkStringOld()
{
}

HK_INLINE char hkStringOld::operator[] (int index) const
{
    return m_string[index];
}

HK_INLINE int hkStringOld::compareTo(const hkStringOld& other) const
{
    return hkString::strCmp( cString(), other.cString() );
}
HK_INLINE int hkStringOld::compareTo(_In_z_ const char* other) const
{
    return hkString::strCmp( cString(), other );
}

HK_INLINE int hkStringOld::compareToIgnoreCase(const hkStringOld& other) const
{
    return hkString::strCasecmp( cString(), other.cString() );
}

HK_INLINE int hkStringOld::compareToIgnoreCase(_In_z_ const char* other) const
{
    return hkString::strCasecmp( cString(), other );
}

HK_INLINE hkBool hkStringOld::operator< (const hkStringOld& other) const
{
    return compareTo(other) < 0;
}

HK_INLINE hkBool hkStringOld::operator== (const hkStringOld& other) const
{
    return compareTo(other) == 0;
}
HK_INLINE hkBool hkStringOld::operator!= (const hkStringOld& other) const
{
    return compareTo(other) != 0;
}
HK_INLINE hkBool hkStringOld::operator== (_In_z_ const char* other) const
{
    return compareTo(other) == 0;
}
HK_INLINE hkBool hkStringOld::operator!= (_In_z_ const char* other) const
{
    return compareTo(other) != 0;
}

HK_INLINE void hkStringOld::setCapacity(int capacity)
{
    m_string.reserve( capacity+1 );
}



HK_INLINE int hkStringOld::getCapacity() const
{
    return m_string.getCapacity();
}

HK_INLINE const hkArray<char>& hkStringOld::getArray() const
{
    return m_string;
}

HK_INLINE hkBool hkStringOld::beginsWith (const hkStringOld& other) const
{
    return this->beginsWith( other.cString() );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
