// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Container/Set/hkSet.h>

#ifdef HK_MEMORY_TRACKER_ENABLE
#include <Common/Base/Memory/Tracker/hkMemoryTrackerSnapshot.h>
#include <Common/Base/Memory/Tracker/hkMemoryTrackerRegistry.h>

namespace
{
    struct AnyArr
    {
        void* ptr;
        int size;
        int cap;
    };
    struct AnySet
    {
        AnyArr m_elem;
        int m_numElems;
    };
}

void HK_CALL hkReflect::Tracker::hkSetHandlerGeneric(const Var& var, hkMemoryTrackerSnapshot& snapshot, int elemSize)
{
    const AnySet* set = static_cast<const AnySet*>(var.getAddress());
    if (set->m_elem.ptr)
    {
        // Track the buffer.
        hkMemoryTrackerSnapshot::Block block("buffer_hkSet", set->m_elem.ptr, set->m_elem.cap * elemSize);
        snapshot.addLinkedBlock(block, true);
    }
}


void HK_CALL hkReflect::Tracker::hkSetHandlerPointer(const Var& var, hkMemoryTrackerSnapshot& snapshot, hkMemoryTracker::Handle elemHandle)
{
    // Track the buffer.
    hkSetHandlerGeneric(var, snapshot, sizeof(void*));
    const AnySet* set = static_cast<const AnySet*>(var.getAddress());
    if (set->m_numElems)
    {
        const hkReflect::Type* ptrType = hkMemoryTrackerRegistry::getInstance().typeFromHandle(elemHandle);
        HK_ASSERT_NO_MSG(0xec286c0, ptrType);
        hkReflect::ArrayValue elems(set->m_elem.ptr, set->m_elem.size, ptrType);
        for (int i = 0; i < elems.getCount(); ++i)
        {
            const void* key = *reinterpret_cast<const void* const*>(elems[i].getAddress());
            
            if (reinterpret_cast<hkUlong>(key) != -1 && key != HK_NULL)
            {
                // Consider a key as valid if != -1.
                
                
                snapshot.addLink(key);
            }
        }
    }
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
