// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Container/RelArray/hkRelArrayUtil.h>

template<typename EnclosingClass>
hkRelArrayBuilder<EnclosingClass>::hkRelArrayBuilder(_In_ EnclosingClass* enclosingObject) : m_enclosingObject(enclosingObject), m_offsetSoFar(0)
{
}

template<typename EnclosingClass>
template<typename RelArrayType>
RelArrayType* hkRelArrayBuilder<EnclosingClass>::addRelArray(hkArray<RelArrayType>& relArray)
{
    //HK_ASSERT(0x4204afe6, size >= 0 && size < 65536, "Array size too large for hkRelArray");
    //HK_ASSERT(0x539c546b, (size * hkSizeOf(RelArrayType) + m_offsetSoFar) < 65536, "Object too large for hkRelArray");
    const int size = relArray.getSize();

    // Pad to 16 bytes
    m_offsetSoFar = HK_NEXT_MULTIPLE_OF(hkRelArrayUtil::RELARRAY_ALIGNMENT, m_offsetSoFar);
    RelArrayType* oldPtr = relArray.begin();
    relArray._setDataUnchecked(reinterpret_cast<RelArrayType*>(hkSizeOf(EnclosingClass) + reinterpret_cast<char *>(m_enclosingObject) + m_offsetSoFar), size, relArray.getCapacityAndFlags());
    //new(&relArray) hkRelArray<RelArrayType>(hkUint16(size), reinterpret_cast<void*>(hkSizeOf(EnclosingClass) + reinterpret_cast<char *>(m_enclosingObject) + m_offsetSoFar));
    m_offsetSoFar += size * hkSizeOf(RelArrayType);
    return oldPtr;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
