// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Container/RelArray/hkRelArrayUtil.h>

hkRelArrayUtil::hkRelArrayUtil(int baseSize)
    : m_numInfo(0)
    , m_baseSize( HK_NEXT_MULTIPLE_OF(HK_REAL_ALIGNMENT,baseSize) )
    , m_totalSize(m_baseSize)
{
}

void hkRelArrayUtil::addRelArray(const hkReflect::Var& srcObj, _In_ const hkReflect::Type* dstType, _In_z_ const char* relArrayMemberName)
{
    const hkReflect::ArrayVar srcArray = srcObj[relArrayMemberName];
    if (!srcArray.isValid())
    {
        return;
    }

    HK_ASSERT_NO_MSG(0x4f1a4bef, dstType->extendsOrEquals<hkReferencedObject>());
    const hkReflect::RecordType* dstRec = dstType->asRecord();
    hkReflect::DataFieldDecl dstField = dstRec->findField(relArrayMemberName, true).asDataField();
    const hkReflect::Type* dstElem = dstField.getType()->asArray()->getSubType();

    // we'll assume all relarray data is aligned which massively simplifies bookkeeping
    Info& info = m_info[m_numInfo++];
    info.numElem = srcArray.getCount();
    info.sizeBlock = info.numElem * dstElem->getSizeOf();
    info.sizeBlock = HK_NEXT_MULTIPLE_OF(HK_REAL_ALIGNMENT, info.sizeBlock);
    info.offsetOfMember = dstField.getOffset();

    m_totalSize += info.sizeBlock;
}

void* hkRelArrayUtil::allocate() const
{
    void* block = hkMemHeapBlockAlloc<void>(m_totalSize);
    hkMemUtil::memSet(block, 0, m_totalSize);
    hkReferencedObject* refObj = new (block) hkReferencedObject();
    refObj->setMemorySizeFlagsAndReferenceCount(m_totalSize, 0);

    int curOffset = m_baseSize;
    for( int i = 0; i < m_numInfo; ++i )
    {
        struct RelArray
        {
            hkUint16 m_size;
            hkUint16 m_offset;
        };
        const Info& info = m_info[i];
        RelArray* ret = (RelArray*)hkAddByteOffset(block, info.offsetOfMember);
        ret->m_offset = hkUint16(curOffset - info.offsetOfMember);
        ret->m_size = hkUint16(info.numElem);
        curOffset += info.sizeBlock;
    }
    return block;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
