// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template <typename T>
HK_INLINE hkRelArray<T>::hkRelArray(hkUint16 size, _In_bytecount_(sizeof(T)*size) const void* ptr) : m_size(size)
{
    HK_ASSERT(0x5259899b, (reinterpret_cast<hkUlong>(ptr) & hkUlong(0x0f)) == 0, "Incorrect alignment for hkRelArray member");
    m_offset = hkUint16(reinterpret_cast<const char*>(ptr) - reinterpret_cast<const char*>(this));
}

template <typename T>
HK_INLINE void hkRelArray<T>::set(hkUint16 size, _In_bytecount_(sizeof(T)*size) const void* ptr)
{
    HK_ASSERT(0x5259899b, (reinterpret_cast<hkUlong>(ptr) & hkUlong(0x0f)) == 0, "Incorrect alignment for hkRelArray member");
    m_size = size;
    m_offset = hkUint16(reinterpret_cast<const char*>(ptr) - reinterpret_cast<const char*>(this));
}

template <typename T>
HK_INLINE const T& hkRelArray<T>::operator [](int index) const
{
    HK_ASSERT(0x46e01b1d, (index >= 0) && (index < m_size), "Invalid index in hkRelArray");
    const T* ptr = reinterpret_cast<const T*>(reinterpret_cast<const char*>(this) + m_offset);
    return ptr[index];
}

template <typename T>
HK_INLINE T& hkRelArray<T>::operator [](int index)
{
    HK_ASSERT(0x4921797f, (index >= 0) && (index < m_size), "Invalid index in hkRelArray");
    T* ptr = reinterpret_cast<T*>(reinterpret_cast<char*>(this) + m_offset);
    return ptr[index];
}

template <typename T>
HK_ALWAYS_INLINE hkUint16 hkRelArray<T>::getSize() const
{
    return m_size;
}

template <typename T>
HK_INLINE hkUint16 hkRelArray<T>::getOffset() const
{
    return m_offset;
}

template <typename T>
HK_ALWAYS_INLINE const T* hkRelArray<T>::begin() const
{
    return reinterpret_cast<const T*>(reinterpret_cast<const char*>(this) + m_offset);
}

template <typename T>
HK_ALWAYS_INLINE T* hkRelArray<T>::begin()
{
    return reinterpret_cast<T*>(reinterpret_cast<char*>(this) + m_offset);
}

template <typename T>
HK_ALWAYS_INLINE const T* hkRelArray<T>::end() const
{
    return reinterpret_cast<const T*>(reinterpret_cast<const char*>(this) + m_offset) + m_size;
}

template <typename T>
HK_ALWAYS_INLINE T* hkRelArray<T>::end()
{
    return reinterpret_cast<T*>(reinterpret_cast<char*>(this) + m_offset) + m_size;
}

template <typename T>
template <typename U>
hkRelArray<T>::operator hkArrayView<U>() const
{
    // Trust implicit conversion of hkArrayView<T> => hkArrayView<U>.
    return hkArrayView<const T>(begin(), getSize());
}

template <typename T>
hkArrayView<T> hkRelArray<T>::view()
{
    return hkArrayView<T>(begin(), getSize());
}

template <typename T>
hkArrayView<const T> hkRelArray<T>::view() const
{
    return hkArrayView<const T>(begin(), getSize());
}

template <typename T>
HK_INLINE void hkRelArray<T>::_setSize(int size)
{
    HK_ASSERT_NO_MSG( 0xf034deed, hkUint32(size) <= 0xffff );   // must fit into 16 bit
    m_size = hkUint16(size);
}

template <typename T>
HK_INLINE void hkRelArray<T>::_setOffset(int offset)
{
    HK_ASSERT_NO_MSG( 0xf034defd, hkUint32(offset) <= 0xffff ); // must fit into 16 bit
    m_offset = hkUint16(offset);
}

template <typename T>
HK_INLINE _Ret_notnull_ void* hkRelArray<T>::operator new(hk_size_t size, _In_ hkRelArray<T>* object)
{
    HK_ASSERT(0x1f4a821b, size == hkSizeOf(hkRelArray<T>), "Invalid size for hkRelArray placement");
    return object;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
