// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

template <typename T>
class hkRelArray
{
    public:

        HK_DECLARE_CLASS(hkRelArray, NewPlacement, Reflect);
        HK_REFLECT_AS_ARRAY(&hkRelArray_ArrayImpl::s_instance, T);
        HK_RECORD_ATTR( hk::AddOptional(Opt::ALLOC_IMPL, HK_NULL) );
        HK_RECORD_ATTR( hk::ReflectDetails(fields=true) );

        HK_INLINE _Ret_notnull_ void* operator new(hk_size_t size, _In_ hkRelArray<T>* object);

        // RelArray can not be directly reflected or allocated
        HK_ALWAYS_INLINE hkRelArray() {}

        // Should be constructed in-place
        HK_INLINE hkRelArray(hkUint16 size, _In_bytecount_(sizeof(T)*size) const void* ptr);

        HK_INLINE  void set(hkUint16 size, _In_bytecount_(sizeof(T)*size) const void* ptr);

        HK_ALWAYS_INLINE ~hkRelArray() {}

        /// Get array element. Individual elements may be changed,
        /// however the size and storage of the array is fixed
        HK_INLINE T& operator [](int index);
        /// Get array element. Individual elements may be changed,
        /// however the size and storage of the array is fixed
        HK_INLINE const T& operator [](int index) const;

        /// Get array size
        HK_ALWAYS_INLINE hkUint16 getSize() const;
        /// Get array storage offset
        HK_INLINE hkUint16 getOffset() const;

        /// Read-only member access
        HK_ALWAYS_INLINE const T* begin() const;

        /// Member access
        HK_ALWAYS_INLINE T* begin();

        /// Returns a const pointer to the 'one past the last' element.
        HK_ALWAYS_INLINE const T* end() const;

        /// Returns a pointer to the 'one past the last' element.
        HK_ALWAYS_INLINE T* end();

        /// Return an array view of U. This is only allowed if T is convertible to U and both have the same size (as with hkArray).
        template<typename U> HK_INLINE operator hkArrayView<U>() const;

        /// Return a view into this array.
        /// \see hkArrayView
        HK_INLINE hkArrayView<T> view();

        /// Return a read-only view into this array.
        /// \see hkArrayView
        HK_INLINE hkArrayView<const T> view() const;

        /// Set the size directly. For advanced use only
        HK_INLINE void _setSize(int size);

        /// Set the offset directly. For advanced use only
        HK_INLINE void _setOffset(int offset);

    protected:

        hkRelArray(const hkRelArray&); //Not implemented
        void operator=(const hkRelArray&); //Not implemented

        hkUint16 m_size;
        hkUint16 m_offset;
};

struct HK_EXPORT_COMMON hkRelArray_ArrayImpl : public hkReflect::Detail::ArrayImpl
{
    static const hkRelArray_ArrayImpl s_instance;
    hkRelArray_ArrayImpl()  { /*keep clang happy*/ }
    hkResult getValue(_In_ const void* arrAddr, _In_ const hkReflect::ArrayType* arrType, _Out_ hkReflect::ArrayValue* val) const HK_OVERRIDE;
    hkResult setNumElements(_In_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int len) const HK_OVERRIDE;
    AllocResult allocateElements(void* arrAddr, const hkReflect::ArrayType* arrType, hkReflect::QualType elemType, int len) const HK_OVERRIDE;
    hkResult inplaceFixup( void* self, const hkReflect::Type* selfType, void* target, const hkReflect::Type* targetType, int count) const HK_OVERRIDE;
};

#include <Common/Base/Container/RelArray/hkRelArray.inl>
#include <Common/Base/_Auto/TemplateTypes/hkRelArray_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
