// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Container/RelArray/hkRelArray.h>


namespace
{
    struct LikeRelArray { hkUint16 size; hkUint16 offset; };
    HK_COMPILE_TIME_ASSERT(sizeof(LikeRelArray)==sizeof(hkRelArray<int>));
}

hkResult hkRelArray_ArrayImpl::getValue(_In_ const void* arrAddr, _In_ const hkReflect::ArrayType* arrType, _Out_ hkReflect::ArrayValue* val) const
{
    const LikeRelArray* array = static_cast<const LikeRelArray*>(arrAddr);
    *val = hkReflect::ArrayValue( const_cast<LikeRelArray*>(hkAddByteOffset(array, array->offset)), array->size, arrType->getSubType() );
    return HK_SUCCESS;
}

hkResult hkRelArray_ArrayImpl::setNumElements(_In_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, int len) const
{
    const LikeRelArray* a = static_cast<LikeRelArray*>(arrAddr);
    return len == a->size ? HK_SUCCESS : HK_FAILURE;
}

hkReflect::Detail::ArrayImpl::AllocResult hkRelArray_ArrayImpl::allocateElements(_In_ void* arrAddr, _In_ const hkReflect::ArrayType* arrType, hkReflect::QualType elemType, int len) const
{
    const LikeRelArray* a = static_cast<LikeRelArray*>(arrAddr);
    if (elemType && elemType->equals(arrType->getSubType()) && len == a->size)
    {
        return ALLOC_SUCCESS;
    }
    return ALLOC_FAILURE;
}

hkResult hkRelArray_ArrayImpl::inplaceFixup( _Inout_ void* self, _In_ const hkReflect::Type* selfType, _In_ void* target, _In_ const hkReflect::Type* targetType, int count) const
{
    LikeRelArray* a = static_cast<LikeRelArray*>(self);
    a->offset = hkLosslessCast<hkUint16>( hkGetByteOffset(self, target) );
    a->size = hkLosslessCast<hkUint16>(count);
    return HK_SUCCESS;
}

const hkRelArray_ArrayImpl hkRelArray_ArrayImpl::s_instance;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
