// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


/// A FIFO circular queue
/// The element type "T" must be movable via memmove.
/// In particular, T may not be hkInplaceArray or any type with internal pointers.
template <typename T>
class hkQueue
{
    public:
        HK_DECLARE_CLASS(hkQueue, NewOpaque ); 

            /// Creates a zero length queue.
        hkQueue();

            /// Creates an queue of capacity n. All elements are uninitialized.
        hkQueue( int capacity );

            /// Deallocates queue memory.
        ~hkQueue();

            // Allocates more internal queue storage
        inline void setCapacity(int n);

            /// Pushes a new element to the back of the queue and expands the storage if necessary.
        inline void enqueue( const T& element );

            /// Pushes a new element to the front of the queue and expands the storage if necessary.
        inline void enqueueInFront( const T& element );

            /// Fills in the data with the element at the front of the queue
        inline void dequeue( T& data );

            /// Fills in the data with the element at the front of the queue but does not modify the queue
        inline void peek( T& data ) const;

            /// Clears the queue
        inline void clear();

            /// Clears the queue and deallocates used memory
        inline void clearAndDeallocate();

            /// Are there any elements left on the queue?
        inline hkBool isEmpty() const;

            /// How many elements are on the queue?
        inline int getSize() const;

            /// Returns the total capacity of the queue storage
        inline int getCapacity() const;

            /// Read-only access to the data pointer
        inline const T* getData() const;

            /// Read-only access to the nth element from the front of the queue
        inline const T& getElement(int idx) const;

            /// For internal use
        inline int _getHead() const;
        inline int _getTail() const;

            /// Set the initial capacity for the queue.
            /// This must be called before any elements have been added to the queue.
        //inline void setInitialCapacity( int capacity );

    private:

        inline void increaseCapacity();

            // frees the internal storage
        void releaseMemoryWithoutCallingDestructors();

            // queue memory management
        T* m_data;
        int m_capacity;

            // queue FIFO management
        int m_head; // first out
        int m_tail; // end of queue
        int m_elementsInUse;
};

#include <Common/Base/Container/Queue/hkQueue.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
