// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template < typename KEY, typename VAL, typename OPS >
HK_ALWAYS_INLINE typename hkMapBase<KEY,VAL,OPS>::Iterator hkMapBase<KEY,VAL,OPS>::getIterator() const
{
    int i;
    for( i = 0; i <= m_hashMod; ++i )
    {
        if( OPS::isValid( m_elem[i].key ) )
        {
            break;
        }
    }

    return HK_MAP_INDEX_TO_ITERATOR(i);
}

template < typename KEY, typename VAL, typename OPS >
HK_ALWAYS_INLINE const KEY& hkMapBase<KEY, VAL, OPS>::getKey(_In_ Iterator it) const
{
    int i = HK_MAP_ITERATOR_TO_INDEX(it);
    HK_ASSERT_NO_MSG(0x7f305156, i>=0 && i<=m_hashMod);
    return m_elem[i].key;
}

template < typename KEY, typename VAL, typename OPS >
HK_ALWAYS_INLINE VAL& hkMapBase<KEY, VAL, OPS>::getValue(_In_ Iterator it) const
{
    int i = HK_MAP_ITERATOR_TO_INDEX(it);
    HK_ASSERT_NO_MSG(0x7f305156, i>=0 && i<=m_hashMod);
    return m_elem[i].val;
}

template < typename KEY, typename VAL, typename OPS >
HK_ALWAYS_INLINE void hkMapBase<KEY, VAL, OPS>::setValue(_In_ Iterator it, const VAL& val)
{
    int i = HK_MAP_ITERATOR_TO_INDEX(it);
    HK_ASSERT_NO_MSG(0x7f305156, i>=0 && i<=m_hashMod);
    m_elem[i].val = val;
}

template < typename KEY, typename VAL, typename OPS >
HK_ALWAYS_INLINE typename hkMapBase<KEY, VAL, OPS>::Iterator hkMapBase<KEY, VAL, OPS>::getNext(_In_ Iterator it) const
{
    int i = HK_MAP_ITERATOR_TO_INDEX(it);
    HK_ASSERT_NO_MSG(0x7f305156, i>=0 && i<=m_hashMod);
    for( i += 1; i <= m_hashMod; ++i )
    {
        if( OPS::isValid( m_elem[i].key ) )
        {
            break;
        }
    }
    return HK_MAP_INDEX_TO_ITERATOR(i);
}

template < typename KEY, typename VAL, typename OPS >
HK_ALWAYS_INLINE hkBool hkMapBase<KEY, VAL, OPS>::isValid(_In_ Iterator it) const
{
    // range [0, hashMod] is valid
    // hashMod+1 invalid
    // anything else is bad input
    int i = HK_MAP_ITERATOR_TO_INDEX(it);
    HK_ASSERT_NO_MSG(0x7f305156, i>=0 && i<=m_hashMod+1);
    return i <= m_hashMod;
}

namespace hkReflect
{
namespace Tracker
{
#if defined(HK_MEMORY_TRACKER_ENABLE)
    HK_EXPORT_COMMON void HK_CALL hkMapHandlerBuiltin(const Var& var, hkMemoryTrackerSnapshot& snapshot,
        hkMemoryTracker::Handle pairHandle, int keySize, int pairSize);
    HK_EXPORT_COMMON void HK_CALL hkMapHandlerGeneric(const Var& var, hkMemoryTrackerSnapshot& snapshot, int elemSize);

    template<typename KEY, typename VAL, bool TRACKED> struct hkMapHandlerHelper;

    template<typename KEY, typename VAL>
    struct hkMapHandlerHelper<KEY, VAL, true>
    {
        static void HK_CALL func(const Var& var, hkMemoryTrackerSnapshot& snapshot)
        {
            typedef HK_REFLECT_RESOLVE(KEY) KeyType;
            typedef HK_REFLECT_RESOLVE(VAL) ValType;
            typedef hkTuple<KeyType, ValType> Pair;
            if (hkTrait::IsBuiltinType<KeyType>::Result)
            {
                hkMapHandlerBuiltin(var, snapshot, HK_TRACKER_GET_HANDLE_UNCHECKED(Pair),
                    sizeof(KeyType), sizeof(Pair));
            }
            else
            {
                hkMapHandlerGeneric(var, snapshot, sizeof(Pair));
            }
        }
    };

    template<typename KEY, typename VAL>
    struct hkMapHandlerHelper<KEY, VAL, false>
    {
        static void HK_CALL func(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot) {}
    };

    template<typename KEY, typename VAL, typename Allocator>
    struct hkMapHandler : public hkMapHandlerHelper< KEY, VAL, hkContainerAllocatorIsTracked<Allocator>::result > {};
#else
    template<typename KEY, typename VAL, typename Allocator>
    struct hkMapHandler { static void HK_CALL func(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot) {} };
#endif
}
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
