// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Container/PointerMap/hkMap.h>
#include <Common/Base/Container/PointerMap/hkMap.hxx>

template class HK_EXPORT_COMMON hkMapBase<unsigned int,unsigned int>;
template class HK_EXPORT_COMMON hkMap<unsigned int,unsigned int>;

template class HK_EXPORT_COMMON hkMapBase<unsigned long,unsigned long>;
template class HK_EXPORT_COMMON hkMap<unsigned long,unsigned long>;

template class HK_EXPORT_COMMON hkMapBase<unsigned long long,unsigned long long>;
template class HK_EXPORT_COMMON hkMap<unsigned long long,unsigned long long>;

#if defined(HK_MEMORY_TRACKER_ENABLE)
#include <Common/Base/Memory/Tracker/hkMemoryTrackerSnapshot.h>
#include <Common/Base/Memory/Tracker/hkMemoryTrackerRegistry.h>

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    struct AnyMap
    {
        void* m_elem;
        int m_numElems;
        int m_hashMod;
    };
}

void hkReflect::Tracker::hkMapHandlerGeneric(const Var& var, hkMemoryTrackerSnapshot& snapshot, int elemSize)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;

    // Tracking the elements in general needs visibility of the MapOps (specifically MapOps::equal) in the
    // reflection files, which is not guaranteed/enforceable at the moment, so we track only the buffer.
    const AnyMap* map = static_cast<const AnyMap*>(var.getAddress());
    if (map->m_elem)
    {
        // Track the buffer
        hkMemoryTrackerSnapshot::Block block("buffer_hkMap", map->m_elem, (map->m_hashMod + 1) * elemSize);
        snapshot.addLinkedBlock(block, true);
    }
}

void hkReflect::Tracker::hkMapHandlerBuiltin(const Var& var, hkMemoryTrackerSnapshot& snapshot,
    hkMemoryTracker::Handle pairHandle, int keySize, int pairSize)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;

    // Track the buffer.
    hkMapHandlerGeneric(var, snapshot, pairSize);
    const AnyMap* map = static_cast<const AnyMap*>(var.getAddress());
    if (map->m_numElems)
    {
        const hkReflect::Type* pairType = hkMemoryTrackerRegistry::getInstance().typeFromHandle(pairHandle);
        HK_ASSERT_NO_MSG(0xd6d9628, pairType);
        // Check if there are pointers in the type.
        if (snapshot.addType(pairType))
        {
            hkReflect::ArrayValue elems(map->m_elem, map->m_hashMod + 1, pairType);
            for (int i = 0; i < elems.getCount(); ++i)
            {
                // Consider a key as valid if != -1.
                
                
                const void* key = elems[i].getAddress();
                hkInt64 minusOne = -1;
                
                if (hkString::memCmp(key, &minusOne, keySize))
                {
                    snapshot.addLinkedBlock(
                        hkMemoryTrackerSnapshot::Block(HK_NULL, key, pairType->getSizeOf(), pairType), false);
                }
            }
        }
    }
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
