// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/PointerMap/hkPointerMap.h>

    /// An hkPointerMap that uses a stack allocation for its initial memory buffer.
template <typename K, typename V, typename Allocator=hkContainerHeapAllocator>
class hkLocalPointerMap : public hkPointerMap<K,V,Allocator>
{
    public:

            /// Construct with enough stack memory to store numKeys keys.
        HK_INLINE hkLocalPointerMap( int numKeys )
        :   hkPointerMap<K,V,Allocator>::hkPointerMap(hkPointerMap<K,V,Allocator>::UNINITIALIZED)
        {
            m_numData = hkPointerMap<K,V,Allocator>::m_map.getSizeInBytesFor( numKeys );
            m_data = hkAllocateStack<char>( m_numData );
            hkPointerMap<K,V,Allocator>::m_map.init( m_data, m_numData );
        }

        HK_INLINE ~hkLocalPointerMap()
        {
            // Clear the map here before hkMap destructor is called to prevent clearing it once is has been deallocated
            hkPointerMap<K,V,Allocator>::m_map.clearAndDeallocate();

            hkDeallocateStack<char>( m_data, m_numData );
        }

            /// Calls hkPointerMap::insert() and asserts that a heap allocation did not occur.
        HK_INLINE hkBool32 insert( K key, V val )
        {
            HK_ASSERT( 0x6175b472, (hkPointerMap<K,V,Allocator>::getSize()) < (hkPointerMap<K,V,Allocator>::getCapacity()), "initial size too small, a heap allocation occured" );
            return hkPointerMap<K,V,Allocator>::insert( key, val );
        }

    private:

            // Memory allocated on the stack.
        char* m_data;

            // The number of bytes allocated.
        int m_numData;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
