// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// this: #include <Common/Base/Container/LocalArray/hkLocalBuffer.h>


template <typename T>
class hkFixedArray
{
    public:
        HK_DECLARE_CLASS(hkFixedArray<T>, NewOpaque); 

            /// Read/write access to the i'th element.
        HK_ALWAYS_INLINE T& operator[] (int i);

            /// Read only access to the i'th element.
        HK_ALWAYS_INLINE const T& operator[] (int i) const;

            /// Returns an STL-like iterator to the first element.
        HK_ALWAYS_INLINE T* begin();

            /// Returns an STL-like iterator to the 'one past the last' element.
        HK_ALWAYS_INLINE const T* begin() const;

#       if defined(HK_DEBUG)
        HK_ALWAYS_INLINE int getSizeDebug() const { return m_size; }
#       endif

        HK_INLINE   hkFixedArray(_In_count_(n) T* t, int n)
            : m_data(t)
        {
            HK_ON_DEBUG(m_size = n);
        }

    protected:

        HK_INLINE   hkFixedArray(){}

        T* m_data;
        int m_size;
};


/// A buffer going to stack memory.
/// Similar to C-style arrays but with bounds checking.
template <typename T>
class hkLocalBuffer: public hkFixedArray<T>
{
    public:
        HK_DECLARE_CLASS(hkLocalBuffer<T>, NewOpaque); 

            /// Creates a buffer of size n. All elements are uninitialized.
        HK_INLINE hkLocalBuffer(int n, _Reserved_ const char* = HK_NULL );

            /// Deallocates array memory.
        HK_INLINE ~hkLocalBuffer();

        HK_ALWAYS_INLINE int getSize() const;
};

template <typename T>
hkLocalBuffer<T>::hkLocalBuffer( int capacity, _Reserved_ const char* )
{
    this->m_data = hkAllocateStack<T>(capacity);
    this->m_size = capacity;
}

template <typename T>
hkLocalBuffer<T>::~hkLocalBuffer()
{
    hkDeallocateStack(this->m_data, this->m_size);
}

template <typename T>
int hkLocalBuffer<T>::getSize() const
{
    return this->m_size;
}


template <typename T>
T& hkFixedArray<T>::operator[] (int i)
{
    HK_ASSERT_NO_MSG(0x394e9c6c,  i >= 0 && i < m_size );
    return m_data[i];
}

template <typename T>
const T& hkFixedArray<T>::operator[] (int i) const
{
    HK_ASSERT_NO_MSG(0x264718f3,  i >= 0 && i < m_size  );
    return m_data[i];
}

template <typename T>
T* hkFixedArray<T>::begin()
{
    return m_data;
}

template <typename T>
const T* hkFixedArray<T>::begin() const
{
    return m_data;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
