// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// Singly linked list using externally-allocated storage.
    /// NodeType must have a public member NodeType* m_next.
template< typename NodeType>
struct hkIntrusiveSlist
{
    typedef NodeType Node;
    typedef Node* Iterator;

    inline Iterator getIterator()   { return m_head; }
    inline bool isValid(_In_ Iterator n) { return n != HK_NULL; }
    inline Iterator getNext(_In_ Iterator n)    { return n->m_next; }

        /// Insert the given node at the list head.
        /// The node is not copied and must remain valid as long as it remains in the list.
    void insert(_In_ Node* node)
    {
        #ifdef HK_DEBUG_SLOW
            // check it's not already added
            for(Node* n = m_head; n != HK_NULL; n = n->m_next )
            {
                if( n == node )
                {
                    HK_BREAKPOINT(0);
                }
            }
        #endif
        node->m_next = m_head;
        m_head = node;
    }

        /// Search for and remove the given node.
    void remove(_In_ Node* n)
    {
        Node* cur = m_head;
        Node** ptrToCur = &m_head;
        while( cur )
        {
            if( cur == n )
            {
                *ptrToCur = n->m_next;
                return;
            }
            ptrToCur = &cur->m_next;
            cur = cur->m_next;
        }
        //??? not found
    }
    Node* m_head;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
