// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename KEY>
HK_NEVER_INLINE bool hkHashSet<KEY>::insert(const KEY& key)
{
    this->m_index.reserveOneMoreThan(this->m_items.getSize());
    hkUint32 hash = hkHashMapDetail::computeHash(key);
    for(hkHashMapDetail::Entry* entry = this->m_index.getFirstEntry(hash); true; entry = this->m_index.nextEntry(entry))
    {
        if(entry->isEmpty())
        {
            entry->init( hash, this->m_items.getSize() );
            this->m_items.pushBack(key);
            return true;
        }
        else if(hkHashMapDetail::equal(this->m_items[entry->idx], key))
        {
            return false;
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
