// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Container/Hash/hkHashBase.h>

    /// Collection of unique elements.
template<typename KEY>
class hkHashSet : public hkHashBase<KEY>
{
public:

    HK_DECLARE_CLASS(hkHashSet, NewTemplate, Reflect);
    typedef hkHashBase<KEY> HashBase;
    typedef typename HashBase::Iterator Iterator;

        /// Adds the element to the set. Returns true if the elem is new, or false if it was already in the set.
    bool insert(const KEY& key);

        /// Get the element at iterator i.
    const KEY& getElement(Iterator it) const { return this->m_items[it.m_i]; }

        /// Get the item at iterator i.
    const KEY& get(Iterator it) const { return this->m_items[it.m_i]; }

        /// Try to insert element. Elements are unique.
        /// Returns true if the elem is new, or false if it was already in the set.
        /// If insertion fails (due to being unable to expand the table), res is set to HK_FAILURE,
        /// otherwise it is set to HK_SUCCESS.
    bool tryInsert(const KEY& key, hkResult& res) { res = HK_SUCCESS; return insert(key); }

        /// Deprecated, use HashBase::find
    Iterator findElement(const KEY& key) const { return HashBase::find(key); }

    hkArrayView<const KEY> getElements() const { return HashBase::m_items; }
};

#include <Common/Base/Container/Hash/hkHashSet.inl>
#include <Common/Base/_Auto/TemplateTypes/hkHashSet_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
