// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename KEY, typename VALUE>
HK_NEVER_INLINE bool hkHashMap<KEY, VALUE>::insert(const KEY& key, const VALUE& val)
{
    this->m_index.reserveOneMoreThan(this->m_items.getSize());
    hkUint32 hash = hkHashMapDetail::computeHash(key);
    for(hkHashMapDetail::Entry* entry = this->m_index.getFirstEntry(hash); true; entry = this->m_index.nextEntry(entry))
    {
        if(entry->isEmpty())
        {
            entry->init( hash, this->m_items.getSize() );
            typename hkHashMap<KEY, VALUE>::Item& item = this->m_items.expandOne();
            item.m_0 = key;
            item.m_1 = val;
            return true;
        }
        else if(hkHashMapDetail::equal(this->m_items[entry->idx].m_0, key))
        {
            this->m_items[entry->idx].m_1 = val;
            return false;
        }
    }
}


template<typename KEY, typename VALUE>
HK_INLINE hkResult hkHashMap<KEY, VALUE>::get(const KEY& key, _Out_ VALUE* out) const
{
    if(hkHashMapDetail::Entry* slot = this->_findEntry(key))
    {
        *out = this->m_items[slot->idx].m_1;
        return HK_SUCCESS;
    }
    return HK_FAILURE;
}


template<typename KEY, typename VALUE>
template<typename SRCKEY>
HK_NEVER_INLINE typename hkHashMap<KEY, VALUE>::Iterator hkHashMap<KEY, VALUE>::findOrInsertKey(const SRCKEY& key, const VALUE& def)
{
    this->m_index.reserveOneMoreThan(this->m_items.getSize());
    hkUint32 hash = hkHashMapDetail::computeHash(key);
    for(hkHashMapDetail::Entry* entry = this->m_index.getFirstEntry(hash); true; entry = this->m_index.nextEntry(entry))
    {
        if(entry->isEmpty())
        {
            int ret = this->m_items.getSize();
            entry->init( hash, this->m_items.getSize() );
            typename hkHashMap<KEY, VALUE>::Item& item = this->m_items.expandOne();
            item.m_0 = key;
            item.m_1 = def;
            return Iterator(ret, this->m_index.indexFromEntry(entry));
        }
        else if(hkHashMapDetail::equal(this->m_items[entry->idx].m_0, key))
        {
            return Iterator(entry->idx, this->m_index.indexFromEntry(entry));
        }
    }
}

template<typename KEY, typename VALUE>
template<typename FUNCTOR>
HK_NEVER_INLINE typename hkHashMap<KEY, VALUE>::Iterator hkHashMap<KEY, VALUE>::findOrInsertKeyWithFunctor(const KEY& key, const FUNCTOR& functor)
{
    this->m_index.reserveOneMoreThan(this->m_items.getSize());
    hkUint32 hash = hkHashMapDetail::computeHash(key);
    for(hkHashMapDetail::Entry* entry = this->m_index.getFirstEntry(hash); true; entry = this->m_index.nextEntry(entry))
    {
        if(entry->isEmpty())
        {
            int ret = this->m_items.getSize();
            entry->init( hash, this->m_items.getSize() );
            typename hkHashMap<KEY, VALUE>::Item& item = this->m_items.expandOne();
            item.m_0 = key;
            item.m_1 = functor();
            return Iterator(ret, this->m_index.indexFromEntry(entry));
        }
        else if(hkHashMapDetail::equal(this->m_items[entry->idx].m_0, key))
        {
            return Iterator(entry->idx, this->m_index.indexFromEntry(entry));
        }
    }
}

template<typename KEY, typename VALUE>
inline VALUE& hkHashMap<KEY, VALUE>::getOrInsertKey(const KEY& key, const VALUE& def)
{
    Iterator it = findOrInsertKey(key, def);
    return getValue(it);
}

template<typename KEY, typename VALUE>
template<typename FUNCTOR>
inline VALUE& hkHashMap<KEY, VALUE>::getOrInsertKeyWithFunctor(const KEY& key, const FUNCTOR& functor)
{
    Iterator it = findOrInsertKeyWithFunctor(key, functor);
    return getValue(it);
}

template<typename KEY, typename VALUE>
const VALUE& hkHashMap<KEY, VALUE>::getWithDefault(const KEY& key, const VALUE& def) const
{
    if(const hkHashMapDetail::Entry* entry = this->_findEntry(key) )
    {
        return this->m_items[entry->idx].m_1;
    }
    return def;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
