// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Container/Hash/hkHashBase.h>

/// Association of key,value pairs
template<typename KEY, typename VALUE>
class hkHashMap : public hkHashBase< hkHashMapDetail::MapTuple<KEY, VALUE> >
{
public:

    HK_DECLARE_CLASS(hkHashMap, NewTemplate, Reflect);
    typedef hkHashBase< hkHashMapDetail::MapTuple<KEY, VALUE> > HashBase;
    typedef typename HashBase::Iterator Iterator;

    HK_INLINE hkHashMap() {}

        /// Get the key at iterator i.
    HK_INLINE const KEY& getKey(Iterator i) const { return this->m_items[i.m_i].m_0; }

        /// Get the const value at iterator i. The returned reference is valid as long
        /// as the map is not mutated.
    HK_INLINE const VALUE& getValue(Iterator i) const { return this->m_items[i.m_i].m_1; }

        /// Get the value at iterator i. The returned reference is valid as long
        /// as the map is not mutated.
    HK_INLINE VALUE& getValue(Iterator i) { return this->m_items[i.m_i].m_1; }

        /// Overwrite the value at iterator i.
    HK_INLINE void setValue(Iterator i, const VALUE& val) { this->m_items[i.m_i].m_1 = val; }

        /// Insert key with associated value val. Keys are unique.
        /// If key already exists it is overwritten.
        /// Returns true if a new key was inserted.
    bool insert(const KEY& key, const VALUE& val);

        /// If key present, write value into out and return HK_SUCCESS. Else return HK_FAILURE.
    hkResult get(const KEY& key, _Out_ VALUE* out) const;

        /// If key is present return its iterator, else insert (key,val) and return the new iterator.
        /// Thus the returned iterator is always valid.
    template <typename SRCKEY>
    Iterator findOrInsertKey(const SRCKEY& key, const VALUE& def);

        /// Similar to \ref findOrInsertKey, but takes a functor which should
        /// return the default value. This functor is only evaluated if no item
        /// with the given key currently exists and a new one needs to be inserted.
    template <typename FUNCTOR>
    Iterator findOrInsertKeyWithFunctor(const KEY& key, const FUNCTOR& functor);

        /// If key is present return its value, else insert (key,val) and return the new value.
    VALUE& getOrInsertKey(const KEY& key, const VALUE& def);

        /// Similar to \ref getOrInsertKey, but takes a functor which should
        /// return the default value. This functor is only evaluated if no item
        /// with the given key currently exists and a new one needs to be inserted.
    template <typename FUNCTOR>
    VALUE& getOrInsertKeyWithFunctor(const KEY& key, const FUNCTOR& functor);

        /// Return the value associated with key or def if not present.
    HK_INLINE const VALUE& getWithDefault(const KEY& key, const VALUE& def) const;

        /// Deprecated, use HashBase::find instead.
    HK_INLINE Iterator findKey(const KEY& key) const { return HashBase::find(key); }

        /// Deprecated, use HashBase::contains instead.
    HK_INLINE hkBool hasKey(const KEY& key) const { return HashBase::contains(key); }
};

#include <Common/Base/Container/Hash/hkHashMap.inl>
#include <Common/Base/_Auto/TemplateTypes/hkHashMap_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
