// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY       : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// An intrusive linked list that enables enumerating all instances of a class (including across DLL boundaries).
///
/// To make a class T enumerable, derive from hkEnumerable<T>
///
///   class T : public hkEnumerable<T>
///   {
///   };
///
/// and add the following in the corresponding source file:
///
///   HK_ENUMERABLE_CLASS_IMPLEMENTATION(T);
///
/// Instances of the class can be enumerated using 'getFirstInstance' and 'getNextInstance'.
///
/// Note that this list is not thread-safe.
template <typename T>
class hkEnumerable
{
public:
    hkEnumerable()
    {
        m_nextInstance = s_firstInstance;
        s_firstInstance = static_cast<T*>(this);
    }

    hkEnumerable(const hkEnumerable&)
    {
        m_nextInstance = s_firstInstance;
        s_firstInstance = static_cast<T*>(this);
    }

    ~hkEnumerable()
    {
        T** pointerToCurrent = &s_firstInstance;

        while (*pointerToCurrent != this)
        {
            pointerToCurrent = &(*pointerToCurrent)->m_nextInstance;
        }

        *pointerToCurrent = m_nextInstance;
    }

    static _Ret_maybenull_ T* getFirstInstance()
    {
        return s_firstInstance;
    }

    _Ret_maybenull_ T* getNextInstance()
    {
        return m_nextInstance;
    }

private:
    T* m_nextInstance;
    static T* s_firstInstance;
};

/// Insert this macro in a cpp file and pass the class name of the to-be-enumerable class as the parameter.
///
/// See class hkEnumerable for more details.
#define HK_ENUMERABLE_CLASS_IMPLEMENTATION(self) \
  template<> self* hkEnumerable<self>::s_firstInstance = HK_NULL;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
