// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


HK_INLINE hkCommand::hkCommand( PrimaryType type, hkUint16 subType, int sizeInBytes)
{
#if defined (HK_WANT_DETERMINISM_CHECKS)
    // Fill memory for determinism.
    hkString::memSet(this, 0xdead, sizeInBytes);
    // Remember the actual size for determinism checks.
    m_determinismSizeInBytes = hkUint16(sizeInBytes);
#endif
    m_sizePaddedTo16 = hkUint16(HK_NEXT_MULTIPLE_OF(16,sizeInBytes));
    m_filterBits = 0;
    m_primaryType = type;
    m_secondaryType = subType;
}

HK_INLINE void* hkBlockStreamCommandWriter::allocBuffer( int size )
{
    size = HK_NEXT_MULTIPLE_OF( 16, size );
    void* data = m_writer.reserve( size );
    m_writer.advance( size );
    return data;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
