// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Container/CommandStream/hkCommandStream.h>
#include <Common/Base/DebugUtil/DeterminismUtil/hkCheckDeterminismUtil.h>


hkBlockStreamCommandWriter::hkBlockStreamCommandWriter( )
{
}

void hkBlockStreamCommandWriter::exec( const hkCommand& command )
{
    int numBytes = command.m_sizePaddedTo16;
    hkCommand *dst = m_writer.reserve<hkCommand>( numBytes );
    hkString::memCpy4(dst, &command, numBytes>>2);
    m_writer.advance( numBytes );
}

namespace
{
    class ErrorCommandDispatcher: public hkSecondaryCommandDispatcher
    {
    public:
        virtual void exec( const hkCommand& command )
        {
            HK_ASSERTV( 0xf0345456, false, "Unhandled command of type {0}", (int)command.m_primaryType );
        }
        virtual void print( const hkCommand& command, hkOstream& stream ) const
        {
            HK_ASSERTV( 0xf0345456, false, "Unhandled command of type {0}", (int)command.m_primaryType );
        }
    } g_errorDispatcher;

    class NopCommandDispatcher: public hkSecondaryCommandDispatcher
    {
    public:
        virtual void exec( const hkCommand& command ) {}
        virtual void print( const hkCommand& command, hkOstream& stream ) const {}
    } g_nopDispatcher;
}

hkPrimaryCommandDispatcher::hkPrimaryCommandDispatcher()
{
    for (int i=0; i < hkCommand::TYPE_MAX; i++ )
    {
        m_commandDispatcher[i] = &g_errorDispatcher;
    }
    m_commandDispatcher[hkCommand::TYPE_NOP] = &g_nopDispatcher;
}

hkPrimaryCommandDispatcher::~hkPrimaryCommandDispatcher()
{
    for (int i=0; i < hkCommand::TYPE_MAX; i++ )
    {
        //m_commandDispatcher[i]->removeReference();
    }
}

void hkPrimaryCommandDispatcher::registerDispatcher( hkCommand::PrimaryType type, _In_ hkSecondaryCommandDispatcher* dispatcher )
{
    m_commandDispatcher[type] = dispatcher;
}


void hkPrimaryCommandDispatcher::exec( const hkCommand& command )
{
    HK_ASSERT( 0xf0de341d, command.m_primaryType < hkCommand::TYPE_MAX, "Unknown command type" );
    m_commandDispatcher[ command.m_primaryType ]->exec( command );
}

void hkPrimaryCommandDispatcher::print( const hkCommand& command, hkOstream& stream ) const
{
    HK_ASSERT( 0xf0de341d, command.m_primaryType < hkCommand::TYPE_MAX, "Unknown command type" );
    m_commandDispatcher[ command.m_primaryType ]->print( command, stream );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
