// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


template<typename T>
HK_INLINE hkTypedBlockStream<T>::hkTypedBlockStream( hkThreadLocalBlockStreamAllocator* tlAllocator, const char* debugName )
    : hkBlockStream( tlAllocator, debugName )
{}

template<typename T>
HK_INLINE hkTypedBlockStream<T>::hkTypedBlockStream() : hkBlockStream()
{}

template<typename T>
HK_INLINE hkTypedBlockStream<T>::hkTypedBlockStream( const hkTypedBlockStream& ) : hkBlockStream()
{
    HK_ASSERT_NOT_IMPLEMENTED( 0xaf142e10 );
}

template<typename T>
HK_INLINE hkTypedBlockStream<T>::~hkTypedBlockStream()
{}


//////////////////////////////////////////////////////////////////////////
// Reader
//////////////////////////////////////////////////////////////////////////

template <typename T>
HK_INLINE const T* hkTypedBlockStream<T>::Reader::access()
{
    return hkBlockStream::Reader::access<T>();
}

template <typename T>
HK_INLINE const T* hkTypedBlockStream<T>::Reader::advanceAndAccessNext( int thisElemSize )
{
    return hkBlockStream::Reader::advanceAndAccessNext<T>( thisElemSize );
}


//////////////////////////////////////////////////////////////////////////
// Modifier
//////////////////////////////////////////////////////////////////////////

template <typename T>
HK_INLINE T* hkTypedBlockStream<T>::Modifier::access()
{
    return hkBlockStream::Modifier::access<T>();
}

template <typename T>
HK_INLINE T* hkTypedBlockStream<T>::Modifier::advanceAndAccessNext( int thisElemSize )
{
    return hkBlockStream::Modifier::advanceAndAccessNext<T>( thisElemSize );
}


//////////////////////////////////////////////////////////////////////////
// Consumer
//////////////////////////////////////////////////////////////////////////

template <typename T>
HK_INLINE const T* hkTypedBlockStream<T>::Consumer::access()
{
    return (T*)hkBlockStream::Consumer::access();
}

template <typename T>
HK_INLINE const T* hkTypedBlockStream<T>::Consumer::consumeAndAccessNext( int thisElemSize )
{
    return (const T*)hkBlockStream::Consumer::consumeAndAccessNext( thisElemSize );
}


//////////////////////////////////////////////////////////////////////////
// BatchConsumer
//////////////////////////////////////////////////////////////////////////

template<typename T>
HK_ALWAYS_INLINE const T* hkTypedBlockStream<T>::BatchConsumer::access()
{
    return (T*)hkBlockStream::BatchConsumer::access();
}

template<typename T>
HK_ALWAYS_INLINE const T* hkTypedBlockStream<T>::BatchConsumer::consumeAndAccessNext( int thisElemSize )
{
    return (const T*)hkBlockStream::BatchConsumer::consumeAndAccessNext( thisElemSize );
}


//////////////////////////////////////////////////////////////////////////
// BatchConsumerRangeOnly
//////////////////////////////////////////////////////////////////////////

template<typename T>
HK_INLINE const T* hkTypedBlockStream<T>::BatchConsumerRangeOnly::access()
{
    return (T*)hkBlockStream::BatchConsumerBase::access();
}

template<typename T>
HK_INLINE const T* hkTypedBlockStream<T>::BatchConsumerRangeOnly::consumeAndAccessNext( int thisElemSize )
{
    return (const T*)hkBlockStream::BatchConsumerBase::consumeAndAccessNext( thisElemSize );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
