// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Container/BlockStream/hkBlockStream.h>
#include <Common/Base/Container/BlockStream/hkBlockStreamIterators.h>
#include <Common/Base/Container/BlockStream/hkBlockStreamRange.h>

/// A helper version of hkBlockStream for streams whose elements are all of the same type.
/// Its iterators return the type correct automatically, making the calling code simpler.
template<typename T>
class hkTypedBlockStream : public hkBlockStream
{
public:

    HK_DECLARE_CLASS( hkTypedBlockStream, New );

    /// Constructor.
    HK_INLINE hkTypedBlockStream( hkThreadLocalBlockStreamAllocator* tlAllocator, const char* debugName = HK_NULL );

    /// Constructor. You must call init() before you can use this class.
    HK_INLINE hkTypedBlockStream();

    /// Copy constructor.
    HK_INLINE hkTypedBlockStream( const hkTypedBlockStream& other );

    /// Destructor.
    HK_INLINE ~hkTypedBlockStream();

public:

    struct Reader : public hkBlockStream::Reader
    {
        /// Access the current element
        HK_INLINE const T* access();

        /// Advance and access the next element, assumes the current entry is valid
        HK_INLINE const T* advanceAndAccessNext( int thisElemSize = sizeof(T) );
    };

    struct Modifier : public hkBlockStream::Modifier
    {
        /// Access the current element
        HK_INLINE T* access();

        /// Advance and access the next element, assumes the current entry is valid
        HK_INLINE T* advanceAndAccessNext( int thisElemSize = sizeof(T) );
    };

    struct Consumer : public hkBlockStream::Consumer
    {
        /// Get the current element.
        HK_INLINE const T* access();

        /// Consume and access the next element, assumes the current entry is valid
        HK_INLINE const T* consumeAndAccessNext( int thisElemSize = sizeof(T) );
    };

    struct BatchConsumer : public hkBlockStream::BatchConsumer
    {
        /// Get the current element.
        HK_ALWAYS_INLINE const T* access();

        /// Consume and access the next element, assumes the current entry is valid
        HK_ALWAYS_INLINE const T* consumeAndAccessNext( int thisElemSize = sizeof(T) );
    };

    struct BatchConsumerRangeOnly : public hkBlockStream::BatchConsumerRangeOnly
    {
        /// Get the current element.
        HK_INLINE const T* access();

        /// Consume and access the next element, assumes the current entry is valid
        HK_INLINE const T* consumeAndAccessNext( int thisElemSize = sizeof(T) );
    };
};

#include <Common/Base/Container/BlockStream/hkTypedBlockStream.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
