// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Container/BlockStream/hkBlockStreamIterators.h>

HK_INLINE hkBlockStream::Range::Range() : m_numElements( 0 ) {}

HK_INLINE void hkBlockStream::Range::clearRange()
{
    m_startBlock = HK_NULL;
    m_numElements = 0;
}

HK_INLINE bool hkBlockStream::Range::isEmpty() const
{
    return m_numElements == 0;
}

HK_INLINE void hkBlockStream::Range::setStartPoint( const hkBlockStream::Writer* HK_RESTRICT writer )
{
    Block* currentBlock = writer->m_currentBlock;
    Block::CountType startByteOffset = Block::CountType( writer->m_currentByteOffset );
    Block::CountType startBlockNumElements = Block::CountType( writer->m_currentBlockNumElems );
    int numElements = -(writer->m_blockStream->m_numTotalElements + writer->m_currentBlockNumElems);

    HK_ASSERT_NO_MSG( 0x5a000196, startBlockNumElements < 0x1000 );

    m_startBlock = currentBlock;
    m_startByteOffset = startByteOffset;
    m_startBlockNumElements = startBlockNumElements;
    m_numElements = numElements;
}

HK_INLINE int hkBlockStream::Range::calcNumberOfItemsWritten( const Writer* it ) const
{
    HK_ASSERT_NO_MSG( 0xf0345456, it->m_blockStream->m_partiallyFreed == false );
    // If the writer has already been finalized the "clever" counting below will be inconsistent because the number of
    // elements in the writer would have been added in the block stream already and thus counted twice.
    HK_ASSERT_NO_MSG( 0xf0345457, it->m_finalized == false );
    // the elements in the last block minus the existing elements in the first
    int currentTotal = it->m_blockStream->m_numTotalElements + it->m_currentBlockNumElems;
    int numElements = currentTotal + m_numElements /* m_numElements is actually negative and initialized in setStartPoint */;
    return numElements;
}

HK_INLINE void hkBlockStream::Range::setEntireStream( hkBlockStream* HK_RESTRICT stream )
{
    bool empty = stream->isEmpty();
    m_startBlock = (!empty) ? stream->beginRw() : HK_NULL;
    m_startByteOffset = 0;
    m_startBlockNumElements = (!empty) ? Block::CountType( m_startBlock->getNumElements() ) : 0;
    m_numElements = stream->getTotalNumElems();
}

HK_INLINE hkBool hkBlockStream::Range::compareRanges( const hkBlockStream::Range& a, const hkBlockStream::Range& b )
{
    if( a.isEmpty() && b.isEmpty() )
    {
        return false;
    }
    if( a.isEmpty() )
    {
        return false;
    }
    if( b.isEmpty() )
    {
        return true;
    }
    if( a.m_startBlock->m_blockIndexInStream == b.m_startBlock->m_blockIndexInStream )
    {
        return a.m_startByteOffset < b.m_startByteOffset;
    }
    return a.m_startBlock->m_blockIndexInStream < b.m_startBlock->m_blockIndexInStream;
}


hkBlockStream::LinkedRange::LinkedRange() :Range(), m_next( HK_NULL ) {}

HK_INLINE void hkBlockStream::LinkedRange::clearRange()
{
    Range::clearRange();
    m_next = HK_NULL;
}

HK_INLINE int hkBlockStream::LinkedRange::getLinkedNumElements() const
{
    // Iterate over all linked ranges for this entry, summing their element counts.
    const LinkedRange* range = this;
    int numElements = 0;

    while( range != HK_NULL )
    {
        numElements += range->getNumElements();
        range = range->m_next;
    }

    return numElements;
}

template<typename T>
HK_INLINE T* hkBlockStream::LinkedRange::appendPersistentRange( T* range )
{
    HK_ASSERT( 0xf0ed3454, range->m_numElements, "You can only append non empty ranges" );
    HK_ASSERT( 0xeeed3454, range->m_next == HK_NULL, "You can only append ranges that are not linked" );

    // If the current range is already empty we can re-use it...
    if( m_numElements == 0 )
    {
        HK_ASSERT( 0xeeed3454, m_next == HK_NULL, "You cannot append empty ranges" );
        *((T*) this) = *range;
        return (T*)this;
    }

    // ... otherwise we insert the new range after the current one.
    range->m_next = m_next;
    m_next = range;
    return range;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
