// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Container/BlockStream/hkBlockStream.h>

/// A range of elements in a block stream.
/// Ranges point to blocks and not to block streams, so a range will still
/// be valid if a block stream gets appended to another one.
class hkBlockStream::Range
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, Range );

    /// Default constructor, initializes an empty range.
    HK_INLINE Range();

    /// Resets the range to an empty range.
    HK_INLINE void clearRange();

    /// Returns true if the range is empty (equivalent to getNumElements() == 0 ).
    HK_INLINE bool isEmpty() const;

    /// Returns the number of elements in the range.
    HK_INLINE int getNumElements() const { return m_numElements; }

    /// Sets the starting point of the range to the block pointed by the given Writer.
    HK_INLINE void setStartPoint( const Writer* HK_RESTRICT it );

    /// Sets the end point of the range to be the block pointed by the given Writer.
    HK_EXPORT_COMMON void setEndPoint( const Writer* HK_RESTRICT it );

    /// Returns the number of items the writer has written since we called setStartPoint()
    HK_INLINE int calcNumberOfItemsWritten( const Writer* HK_RESTRICT it ) const;

    /// Sets a range to cover a whole stream.
    HK_INLINE void setEntireStream( hkBlockStream* HK_RESTRICT stream );

    /// Returns whether the first given range should be placed before the second one when sorting a list of ranges.
    static HK_INLINE hkBool compareRanges( const Range& a, const Range& b );

public:

    /// A pointer to the block that holds the first element of THIS range.
    HK_ALIGN16( Block* m_startBlock );

    /// The offset of the first element inside the start block (m_startBlock).
    Block::CountType m_startByteOffset;

    /// The number of elements in the first block.
    /// Note: when setStartPoint() is called this is the start element index in the start block.
    Block::CountType m_startBlockNumElements;

    /// The length of THIS range (i.e. the number of elements in THIS range).
    /// Note: this value is negative when not fully initialized.
    int m_numElements;
};


class hkBlockStream::LinkedRange : public Range
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, LinkedRange );

    HK_INLINE LinkedRange();

    /// Append another range to this. The range MUST be persistent in memory as it will be referenced by this.
    template<typename T> HK_INLINE T* appendPersistentRange( T* HK_RESTRICT range );

    /// Resets the range to an empty range.
    HK_INLINE void clearRange();

    /// Get the number of elements of this and all linked ranges.
    HK_INLINE int getLinkedNumElements() const;

public:

    /// A pointer to the next range if several ranges have been linked.
    /// Note: that next range is completely independent of THIS range, i.e. m_numElements does not cross
    /// any range boundaries.
    LinkedRange* m_next;
};

#include <Common/Base/Container/BlockStream/hkBlockStreamRange.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
