// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Container/BlockStream/hkBlockStreamRange.h>

void hkBlockStream::Range::setEndPoint( const Writer* HK_RESTRICT it )
{
    HK_ASSERT_NO_MSG( 0xf0345456, it->m_blockStream->m_partiallyFreed == false );
    // If the writer has already been finalized the """clever""" counting below will be inconsistent because the number of
    // elements in the writer would have been added in the blockstream already and thus counted twice.
    HK_ASSERT_NO_MSG( 0xf0345457, it->m_finalized == false );
    // the elements in the last block minus the existing elements in the first
    int currentTotal = it->m_blockStream->m_numTotalElements + it->m_currentBlockNumElems;
    int numElements = currentTotal + m_numElements /* m_numElements is actually negative and initialized in setStartPoint */;

    HK_ASSERT( 0x30172CEC, m_startBlock->m_blockStream == it->m_blockStream, "Attempting to setEndPoint using a different writer" );
    HK_ASSERT( 0xad341112, numElements >= 0, "Range corrupted." );

    if( numElements )
    {
        hkBlockStream::Block* startBlock = m_startBlock;
        if( (startBlock != it->m_currentBlock) && startBlock->getNumElements() == m_startBlockNumElements )
        {
            // first block is empty,
            // advance to next block
            startBlock = startBlock->m_next;
            m_startBlockNumElements = 0;
            m_startByteOffset = 0;
        }
        if( startBlock == it->m_currentBlock )
        {
            m_startBlockNumElements = hkBlockStream::Block::CountType( it->m_currentBlockNumElems ) - m_startBlockNumElements;
        }
        else
        {
            m_startBlockNumElements = hkBlockStream::Block::CountType( startBlock->getNumElements() - m_startBlockNumElements );
        }
        HK_ASSERT_NO_MSG( 0xf045456, numElements >= m_startBlockNumElements );
        m_startBlock = startBlock;
    }
    m_numElements = numElements;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
