// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//////////////////////////////////////////////////////////////////////////
// Block
//////////////////////////////////////////////////////////////////////////

HK_INLINE hkBlockStream::Block::Block()
{
    setHeaderToZero();
}

HK_INLINE void hkBlockStream::Block::setHeaderToZero()
{
    HK_COMPILE_TIME_ASSERT( (sizeof( Block ) & 0xf) == 0 );
    HK_COMPILE_TIME_ASSERT( (BLOCK_HEADER_SIZE & 0xf) == 0 );
    HK_COMPILE_TIME_ASSERT( HK_OFFSET_OF( Block, m_data ) == BLOCK_HEADER_SIZE );
    // Make sure the two elements fit in the 'packed' variable.
    HK_COMPILE_TIME_ASSERT( sizeof( m_numElementsAndBytesUsed ) >= 2 * sizeof( Block::CountType ) );

    hkString::memClear16( this, BLOCK_HEADER_SIZE >> 4 );
    HK_ON_DEBUG( hkString::memSet( m_data, 0xcf, BLOCK_DATA_SIZE ) );
}

HK_INLINE void* hkBlockStream::Block::begin()
{
    return m_data;
}
HK_INLINE const void* hkBlockStream::Block::begin() const
{
    return m_data;
}

HK_INLINE void* hkBlockStream::Block::end()
{
    return this + 1;
}

HK_INLINE const void* hkBlockStream::Block::end() const
{
    return this + 1;
}

HK_INLINE hkBlockStream::Block::CountType hkBlockStream::Block::getNumElements() const
{
    return static_cast<CountType>(m_numElementsAndBytesUsed);
}

HK_INLINE hkBlockStream::Block::CountType hkBlockStream::Block::getNumBytesUsed() const
{
    return static_cast<CountType>(m_numElementsAndBytesUsed >> 16);
}

HK_INLINE void hkBlockStream::Block::setNumElements( CountType numElements )
{
    m_numElementsAndBytesUsed = ((m_numElementsAndBytesUsed & 0xffff0000) | (static_cast<hkUint32>(numElements)));
}

HK_INLINE void hkBlockStream::Block::setNumBytesUsed( CountType numBytes )
{
    m_numElementsAndBytesUsed = ((static_cast<hkUint32>(numBytes) << 16) | (m_numElementsAndBytesUsed & 0x0000ffff));
}


//////////////////////////////////////////////////////////////////////////
// Stream
//////////////////////////////////////////////////////////////////////////

HK_INLINE hkBlockStream::hkBlockStream( hkThreadLocalBlockStreamAllocator* tlAllocator, const char* debugName )
{
    init( tlAllocator, debugName );
}

hkBlockStream::~hkBlockStream()
{
    HK_ASSERT( 0xf03454ed, m_blocks.getSize() == 0, "You must call clear before the destructor" );
}

HK_INLINE bool hkBlockStream::isEmpty() const
{
    HK_ASSERT( 0xf034dfdf, !m_isLocked, "You cannot use isEmpty() while writing to writer (call writer::finalize() first." );
    return m_numTotalElements == 0;
}

HK_INLINE int hkBlockStream::getTotalNumElems() const
{
    HK_ASSERT( 0xf032defd, m_isLocked == false,
        "You cannot call this function, when non-finalized write itrators are linked to the stream." );
    HK_ASSERT( 0xf032defd, m_partiallyFreed == false,
        "You cannot call this function when some blocks are freed by a hkBlockStream::Consumer" );
    return m_numTotalElements;
}

HK_INLINE int hkBlockStream::getTotalBytesAllocated() const
{
    return m_blocks.getSize() * sizeof( hkBlockStream::Block );
}

HK_INLINE const hkBlockStreamAllocator* hkBlockStream::getAllocator() const
{
    return m_allocator;
}

HK_INLINE const hkBlockStream::Block* hkBlockStream::begin() const
{
    return m_blocks[0];
}

HK_INLINE const hkBlockStream::Block* hkBlockStream::last() const
{
    return m_blocks[m_blocks.getSize() - 1];
}

HK_INLINE hkBlockStream::Block* hkBlockStream::beginRw()
{
    return const_cast<Block*>(begin());
}

HK_INLINE hkBlockStream::Block* hkBlockStream::lastRw()
{
    return const_cast<Block*>(last());
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
