// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/BlockStream/Allocator/hkBlockStreamAllocator.h>

/// Thread local allocator, acts as a cache over a Block Stream allocator.
/// There is one for each thread, which caches a number of blocks.
class HK_EXPORT_COMMON hkThreadLocalBlockStreamAllocator
{
    public:

        enum
        {
            BATCH_ALLOC_SIZE    = 6,    ///< The number of blocks freed/allocated in one go in the m_blockStreamManager
        };

    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, hkThreadLocalBlockStreamAllocator );

        /// Constructor.
        hkThreadLocalBlockStreamAllocator( _In_ hkBlockStreamAllocator* bsAllocator );

        /// Destructor
        ~hkThreadLocalBlockStreamAllocator();

        /// Allocate a block
        hkBlockStreamAllocator::Block* blockAlloc();

        /// Deallocate a block
        void blockFree( _Inout_ hkBlockStreamAllocator::Block* block );

        /// Free a batch
        void blockFreeBatch( _Inout_updates_(nblocks) hkBlockStreamAllocator::Block** blocks, int nblocks );

        /// Clear all locally cached blocks
        void clear();

        /// Get the underlying allocator
        HK_ALWAYS_INLINE hkBlockStreamAllocator* getBlockStreamAllocator() const { return m_blockStreamAllocator; }

    protected:

        void checkConsistency() const;

        /// The underlying block stream allocator.
        hkBlockStreamAllocator* m_blockStreamAllocator;

        /// The locally cached blocks.
        hkBlockStreamAllocator::Block* m_freeBlocks[hkBlockStreamAllocator::MAX_FREE_LIST_SIZE];
        int m_numFreeBlocks;

        /// The number of blocks to cache, according to the allocator. Must be less than MAX_FREE_LIST_SIZE
        const int m_numBlocksToCache;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
