// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/BlockStream/hkBlockStream.h>

/// An interface for allocating fixed sized memory blocks, for use in a hkBlockStream.
class HK_EXPORT_COMMON hkBlockStreamAllocator : public hkReferencedObject
{
    public:

        enum
        {
            MAX_FREE_LIST_SIZE  = 8,    ///< The maximum number of elements cached by thread-local allocators
        };

        typedef hkBlockStream::Block Block;

    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE );

        /// Allocate blocks.
        virtual void blockAllocBatch( _Outptr_result_buffer_(nblocks) Block** blocksOut, int nblocks ) = 0;

        /// Free blocks.
        virtual void blockFreeBatch( _Inout_updates_(nblocks) Block** blocks, int nblocks ) = 0;

        /// Get the current bytes used.
        /// Note that data in the thread local allocator will count as bytes used
        /// (as they are not available to other threads in a worst case scenario).
        virtual int getBytesUsed() const= 0;

        /// Get the peak usage.
        virtual int getMaxBytesUsed() const = 0;

        /// Get the maximum amount of memory that can be allocated through this allocator.
        /// Sets all data to be free, even if there are outstanding allocations.
        /// return the data to the system, to do so use hkFixedBlockStream::clear() or hkDynamicBlockStream::releaseUnusedBlocks()
        virtual void freeAllRemainingAllocations() = 0;

        /// Returns an aggregate on memory statistics of this allocator.
        virtual void getMemoryStatistics( hkMemoryAllocator::MemoryStatistics& statsOut ) const = 0;

        /// Write some high level statistics to the calling thread's monitor stream.
        void exportStatisticsToMonitorStream() const;

        /// Used by the hkThreadLocalBlockStreamAllocator to indicate the preferred caching behavior of this allocator
        virtual int getNumThreadLocalBlocks() const { return MAX_FREE_LIST_SIZE; }

    public:

        static Block* s_safeGuard;      // If you set this, the system will assert if this block is freed
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
