// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : X64 DURANGO
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Fwd/hkwindows.h>

hkDebugBlockStreamAllocator::hkDebugBlockStreamAllocator()
{
    m_totalNumBlocksAllocated = 0;
    m_maxConcurrentBlocksAllocated = 0;

    m_criticalSection = new hkCriticalSection();
}

hkDebugBlockStreamAllocator::~hkDebugBlockStreamAllocator()
{
    delete m_criticalSection;
}

void hkDebugBlockStreamAllocator::blockAllocBatch( Block** blocksOut, int nBlocks )
{
    hkCriticalSectionLock lock(m_criticalSection);

    for(int n = 0; n < nBlocks; n++)
    {
        void* p = HK_NULL;
        hkUint64 offset = 0;
        p = VirtualAlloc(HK_NULL, sizeof(Block), MEM_COMMIT | MEM_RESERVE, PAGE_READWRITE);

        blocksOut[n] = reinterpret_cast<Block*>(p);
        m_liveBlocks.insert(blocksOut[n], offset);

        m_totalNumBlocksAllocated++;
        m_maxConcurrentBlocksAllocated = hkMath::max2( m_maxConcurrentBlocksAllocated, m_liveBlocks.getSize() );
    }
}

void hkDebugBlockStreamAllocator::blockFreeBatch( Block** blocks, int nBlocks )
{
    hkCriticalSectionLock lock(m_criticalSection);

    for(int n = 0; n < nBlocks; n++)
    {
        HK_ASSERT(0x301794D9, m_liveBlocks.contains(blocks[n]), "Freeing unallocated block");
        VirtualFree(blocks[n], sizeof(Block), MEM_DECOMMIT);
        m_liveBlocks.remove(blocks[n]);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
