// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : X64 LINUX64 PS4 DURANGO
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/BlockStream/Allocator/hkBlockStreamAllocator.h>
#include <Common/Base/Container/Hash/hkHashMap.h>

class hkCriticalSection;

// A block stream allocator that allocates virtual memory and never re-uses an address.
// When freeing a block, the memory is freed but kept reserved with no read/write access,
// allowing the operating system to overcommit the memory. Using this, we can more easily
// detect invalid pointers when we read them in the blockstream, allowing us to fail debug
// checks faster, rather than having to rely on [potentially] invalid data later.
class HK_EXPORT_COMMON hkDebugBlockStreamAllocator : public hkBlockStreamAllocator
{
    public:
        HK_DECLARE_CLASS( hkDebugBlockStreamAllocator, New );

        typedef hkBlockStream::Block Block;

        hkDebugBlockStreamAllocator();
        ~hkDebugBlockStreamAllocator();

        // hkBlockStreamAllocator interface
        virtual void blockAllocBatch( Block** blocksOut, int nBlocks ) HK_OVERRIDE;
        virtual void blockFreeBatch( Block** blocks, int nBlocks ) HK_OVERRIDE;
        virtual int getBytesUsed() const HK_OVERRIDE;
        virtual int getMaxBytesUsed() const HK_OVERRIDE;
        virtual void freeAllRemainingAllocations() HK_OVERRIDE;
        virtual void getMemoryStatistics( hkMemoryAllocator::MemoryStatistics& statsOut ) const HK_OVERRIDE;
        virtual int getNumThreadLocalBlocks() const HK_OVERRIDE { return 0; }

    protected:

        hkCriticalSection* m_criticalSection; 
        hkUint64 m_totalNumBlocksAllocated; 
        int m_maxConcurrentBlocksAllocated; 
        hkHashMap<Block*, hkUint64> m_liveBlocks; 
        int m_pageTableSize; 
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
