// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : X64 LINUX64 PS4 DURANGO
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Container/BlockStream/Allocator/Debug/hkDebugBlockStreamAllocator.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

#if defined(HK_PLATFORM_LINUX)
#   include <Common/Base/Container/BlockStream/Allocator/Debug/hkDebugBlockStreamAllocatorLinux.cxx>
#elif defined(HK_PLATFORM_PS4)
#   include <Common/Base/Container/BlockStream/Allocator/Debug/hkDebugBlockStreamAllocatorPS4.cxx>
#elif defined(HK_PLATFORM_WIN64)
#   include <Common/Base/Container/BlockStream/Allocator/Debug/hkDebugBlockStreamAllocatorWindows.cxx>
#else

// Dummy implementation to avoid linker errors
hkDebugBlockStreamAllocator::hkDebugBlockStreamAllocator()
{
    HK_ASSERT(0x30176B5C, false, "Debug block stream allocator not implemented on this platform");
}

hkDebugBlockStreamAllocator::~hkDebugBlockStreamAllocator()
{
}

void hkDebugBlockStreamAllocator::blockAllocBatch( Block** blocksOut, int nBlocks )
{
}

void hkDebugBlockStreamAllocator::blockFreeBatch( Block** blocks, int nBlocks )
{
}

#endif

int hkDebugBlockStreamAllocator::getBytesUsed() const
{
    return sizeof(Block) * m_liveBlocks.getSize();
}

int hkDebugBlockStreamAllocator::getMaxBytesUsed() const
{
    return sizeof(Block) * m_maxConcurrentBlocksAllocated;
}

void hkDebugBlockStreamAllocator::freeAllRemainingAllocations()
{
    hkArray<Block*>::Temp allBlocks;
    for(hkHashMap<Block*, hkUint64>::Iterator iter = m_liveBlocks.getIterator();
            m_liveBlocks.isValid(iter); iter = m_liveBlocks.getNext(iter))
    {
        allBlocks.pushBack( m_liveBlocks.getKey( iter ) );
    }

    blockFreeBatch( allBlocks.begin(), allBlocks.getSize() );
}

void hkDebugBlockStreamAllocator::getMemoryStatistics( hkMemoryAllocator::MemoryStatistics& statsOut ) const
{
    statsOut.m_allocated = m_liveBlocks.getSize() * sizeof(Block);
    statsOut.m_inUse = statsOut.m_allocated;
    statsOut.m_peakInUse = getMaxBytesUsed();
    statsOut.m_available = 0;
    statsOut.m_totalAvailable = HK_INT32_MAX;
    statsOut.m_largestBlock = sizeof(Block);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
