// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename T>
template<typename U>
hkArrayView<T>::hkArrayView( const hkArrayView<U>& rhs )
    : m_begin( hkTrait::ViewAsOther<U, T>::view( rhs.begin() ) ), m_end( hkTrait::ViewAsOther<U, T>::view( rhs.end() ) )
{
    enum
    {
        // Prevent casting from a pointer to some Derived class to a
        // pointer of its base class in case they have different sizes.
        SourceAndTargetHaveTheSameSize = sizeof( typename hkTrait::VoidValue<T>::Type ) == sizeof( typename hkTrait::VoidValue<U>::Type ),
        TargetIsVoid = hkTrait::TypesAreEqual<typename hkTrait::RemoveConst<T>::type, void>::result,
    };
    HK_COMPILE_TIME_ASSERT( SourceAndTargetHaveTheSameSize || TargetIsVoid );
}

template<typename T>
_Ret_notnull_ T* hkArrayView<T>::ptr(_In_range_(>= , 0) int index) const
{
    HK_ASSERT_NO_MSG(0x7f727559, m_begin + index < m_end);
    return m_begin + index;
}

template<typename T>
template<typename U>
typename hkArrayView<T>::iterator hkArrayView<T>::find(const U& u) const
{
    const int index = indexOf(u);
    if (index < 0)
    {
        return end();
    }
    return begin() + index;
}

template<typename T>
template<typename U>
typename hkArrayView<T>::iterator hkArrayView<T>::findLast(const U& u) const
{
    const int index = lastIndexOf(u);
    if(index < 0)
    {
        return end();
    }
    return begin() + index;
}

template<typename T>
template<typename U>
int hkArrayView<T>::indexOf(const U& needle) const
{
    // Store the size on the stack to prevent multiple calls to getSize() in the loop.
    const int size = getSize();
    for (int i = 0; i < size; ++i)
    {
        // No bounds check necessary here, so we are using m_begin directly.
        if (m_begin[i] == needle)
        {
            return i;
        }
    }
    return -1;
}

template<typename T>
template<typename U>
int hkArrayView<T>::lastIndexOf(const U& needle) const
{
    for(int i = getSize() - 1; i >= 0; --i)
    {
        // No bounds check necessary here, so we are using m_begin directly.
        if(m_begin[i] == needle)
        {
            return i;
        }
    }
    return -1;
}

template<typename T>
hkArrayView<T> hkArrayView<T>::ltrim(int n) const
{
    HK_ASSERT_NO_MSG(0x4ca25e39, m_begin + n <= m_end);
    return hkArrayView<T>(m_begin + n, m_end);
}

template<typename T>
hkArrayView<T> hkArrayView<T>::rtrim(int n) const
{
    HK_ASSERT_NO_MSG(0x581a5b78, m_end - n >= m_begin);
    return hkArrayView<T>(m_begin, m_end - n);
}

template<typename T>
hkArrayView<T> hkArrayView<T>::slice(int idx, int num) const
{
    HK_ASSERT_NO_MSG(0x2e3bf824, m_begin + idx + num <= m_end);
    return hkArrayView<T>(m_begin + idx, m_begin + idx + num);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
