// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// A ptr to any memory, described by a Type that can be dynamic.
// Note that on allocate, it will use the default Havok heap. If you want it to use a different
// allocator then you need to make your own version, and point --impl to your Impl that uses your allocator
class HK_EXPORT_COMMON hkVariantArray
{
    public:
        HK_DECLARE_CLASS(hkVariantArray, New, Reflect);
        HK_REFLECT_AS_VARIANT_ARRAY(&hkReflect::Detail::HomogeneousArrayImpl::s_instance);
        HK_RECORD_ATTR(hk::IncludeInMgd(false));
        HK_RECORD_ATTR(hk::MemoryTracker(opaque = true, handler = &trackerHandler));

        inline hkVariantArray() : m_ptr(HK_NULL), m_size(0), m_capacityAndFlags(0), m_type(HK_NULL) {}
        hkVariantArray(const hkVariantArray& rhs);
        ~hkVariantArray();
        hkVariantArray& operator=(const hkVariantArray& rhs);

        /// Allowed only if the types are equal.
        void pushBack(const hkReflect::Var& src);

        HK_ALWAYS_INLINE const void* getData() const { return m_ptr; }
        HK_ALWAYS_INLINE void* getData() { return m_ptr; }
        HK_ALWAYS_INLINE int getSize() const { return m_size; }

        HK_INLINE hkReflect::Var operator[](int index) const
        {
            HK_ASSERT_NO_MSG(0x1602a559, index >= 0 );
            HK_ASSERT_NO_MSG(0x6afed9d7, index < m_size );
            return hkReflect::Var( hkAddByteOffset( m_ptr, m_type->getSizeOf() * index ), m_type );
        }

        /// Allowed only if the types are equal.
        void append( const hkVariantArray& src );

        void clear();

        // May not own pointer, so we dont know (unless we add owner ship flag) when to call this. Up to owning code.
        void clearAndDeallocate();

        inline int getAllocatedSizeInBytes() const { return m_size ? m_size * m_type->getSizeOf() : 0; }

        // Allocated and optionally set Type. If you have not set type already though, null type is not enough
        void allocate(int size, _In_opt_ const hkReflect::Type* type = HK_NULL);

        /// Gets / Sets the type
        inline const hkReflect::QualType& getType() const { return m_type;  }
        void setType(_In_opt_ const hkReflect::Type* type);

        template<typename T>
        void setElement(int index, T const& elem)
        {
            HK_ASSERT_NO_MSG(0x6ea8f300, m_type->equals<T>());
            HK_ASSERT_NO_MSG(0x46b5902f, index < m_size);
            reinterpret_cast<T*>(m_ptr)[index] = elem;
        }

        void setElement(int index, const hkReflect::Var& src);

        template<typename T>
        T& getElement(int index)
        {
            HK_ASSERT_NO_MSG(0x6a20d603, m_type->equals<T>());
            HK_ASSERT_NO_MSG(0x3b088adc, index < m_size);
            return reinterpret_cast<T*>(m_ptr)[index];
        }

        template<typename T>
        operator hkArrayView<T>()
        {
            HK_ASSERT_NO_MSG(0x353a0fcb, m_type.get() == HK_NULL || m_type->equals<T>());
            return hkArrayView<T>(static_cast<T*>(m_ptr), m_size);
        }

        template<typename T>
        operator hkArrayView<const T>() const
        {
            HK_ASSERT_NO_MSG(0x44a02b33, m_type.get() == HK_NULL || m_type->equals<T>());
            return hkArrayView<const T>(static_cast<const T*>(m_ptr), m_size);
        }

        operator hkArrayView<void>()
        {
            return hkArrayView<void>(m_ptr, m_size * m_type->getSizeOf());
        }

        operator hkArrayView<const void>() const
        {
            return hkArrayView<const void>(m_ptr, m_size * m_type->getSizeOf());
        }

    public:
        static void trackerHandler(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot);

    protected:
        void* m_ptr;
        int m_size;
        int m_capacityAndFlags; // should be == size in most cases. Because we use stock HomogeneousArrayImpl it is here. Can make our own with out
        hkReflect::QualType m_type;  // the dynamically created type to nmatch our arbitrary data layout
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
